/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.base;

import org.apache.asterix.om.base.IACursor;
import org.apache.asterix.om.base.IAObject;

public class InMemUtils {
    public static final boolean cursorEquals(IACursor c1, IACursor c2) {
        while (c1.next()) {
            IAObject otherO;
            if (!c2.next()) {
                return false;
            }
            IAObject thisO = c1.get();
            if (thisO.equals(otherO = c2.get())) continue;
            return false;
        }
        return !c2.next();
    }

    public static final int hashCursor(IACursor c) {
        int h = 0;
        while (c.next()) {
            h = h * 31 + c.get().hashCode();
        }
        return h;
    }

    static int hashDouble(double value) {
        long bits = Double.doubleToLongBits(value);
        return (int)(bits ^ bits >>> 32);
    }

    static boolean deepEqualArrays(IAObject[] v1, IAObject[] v2) {
        if (v1.length != v2.length) {
            return false;
        }
        for (int i = 0; i < v1.length; ++i) {
            if (v1[i].deepEqual(v2[i])) continue;
            return false;
        }
        return true;
    }
}

