/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.pointables.nonvisitor;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IJsonSerializable;
import org.apache.hyracks.api.io.IPersistedResourceRegistry;
import org.apache.hyracks.data.std.api.AbstractPointable;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IPointableFactory;
import org.apache.hyracks.data.std.primitive.BytePointable;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.data.std.primitive.LongPointable;
import org.apache.hyracks.data.std.primitive.VarLengthTypeTrait;

public class AIntervalPointable
extends AbstractPointable {
    public static final AIntervalPointableFactory FACTORY = new AIntervalPointableFactory();
    private static final int TAG_SIZE = 1;

    public byte getType() {
        return BytePointable.getByte((byte[])this.bytes, (int)this.start);
    }

    public ATypeTag getTypeTag() {
        return EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(this.getType());
    }

    public void getStart(IPointable start) throws HyracksDataException {
        start.set(this.bytes, this.getIntervalStartOffset(), this.getStartEndSize());
    }

    public void getTaggedStart(DataOutput output) throws HyracksDataException {
        try {
            output.writeByte(this.getType());
            output.write(this.bytes, this.getIntervalStartOffset(), this.getStartEndSize());
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    private int getIntervalStartOffset() {
        return this.start + 1;
    }

    public long getStartValue() throws HyracksDataException {
        switch (this.getTypeTag()) {
            case DATE: 
            case TIME: {
                return IntegerPointable.getInteger((byte[])this.bytes, (int)this.getIntervalStartOffset());
            }
            case DATETIME: {
                return LongPointable.getLong((byte[])this.bytes, (int)this.getIntervalStartOffset());
            }
        }
        throw new HyracksDataException("Unsupported interval type: " + this.getTypeTag() + ".");
    }

    public void getEnd(IPointable end) throws HyracksDataException {
        end.set(this.bytes, this.getEndOffset(), this.getStartEndSize());
    }

    public void getTaggedEnd(DataOutput output) throws HyracksDataException {
        try {
            output.writeByte(this.getType());
            output.write(this.bytes, this.getEndOffset(), this.getStartEndSize());
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    private int getEndOffset() throws HyracksDataException {
        return this.getIntervalStartOffset() + this.getStartEndSize();
    }

    public long getEndValue() throws HyracksDataException {
        switch (this.getTypeTag()) {
            case DATE: 
            case TIME: {
                return IntegerPointable.getInteger((byte[])this.bytes, (int)this.getEndOffset());
            }
            case DATETIME: {
                return LongPointable.getLong((byte[])this.bytes, (int)this.getEndOffset());
            }
        }
        throw new HyracksDataException("Unsupported interval type: " + this.getTypeTag() + ".");
    }

    private int getStartEndSize() throws HyracksDataException {
        switch (this.getTypeTag()) {
            case DATE: 
            case TIME: {
                return 4;
            }
            case DATETIME: {
                return 8;
            }
        }
        throw new HyracksDataException("Unsupported interval type: " + this.getTypeTag() + ".");
    }

    public static final class AIntervalPointableFactory
    implements IPointableFactory {
        private static final long serialVersionUID = 1L;

        public IPointable createPointable() {
            return new AIntervalPointable();
        }

        public ITypeTraits getTypeTraits() {
            return VarLengthTypeTrait.INSTANCE;
        }

        public JsonNode toJson(IPersistedResourceRegistry registry) throws HyracksDataException {
            return registry.getClassIdentifier(this.getClass(), 1L);
        }

        public static IJsonSerializable fromJson(IPersistedResourceRegistry registry, JsonNode json) {
            return FACTORY;
        }
    }
}

