/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.btree.tuples;

import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.storage.am.common.api.IBTreeIndexTupleReference;
import org.apache.hyracks.storage.am.common.tuples.TypeAwareTupleReference;
import org.apache.hyracks.storage.am.common.util.BitOperationUtils;

public class BTreeTypeAwareTupleReference
extends TypeAwareTupleReference
implements IBTreeIndexTupleReference {
    public static final byte UPDATE_BIT_OFFSET = 6;
    protected final boolean updateAware;

    public BTreeTypeAwareTupleReference(ITypeTraits[] typeTraits, boolean updateAware, ITypeTraits nullTypeTraits) {
        super(typeTraits, nullTypeTraits);
        this.updateAware = updateAware;
    }

    public boolean flipUpdated() {
        if (this.updateAware) {
            int mask = 64;
            if ((this.buf[this.tupleStartOff] & 0x40) == 0) {
                int n = this.tupleStartOff;
                this.buf[n] = (byte)(this.buf[n] | 0x40);
                return true;
            }
            int n = this.tupleStartOff;
            this.buf[n] = (byte)(this.buf[n] & 0xFFFFFFBF);
            return false;
        }
        return false;
    }

    public boolean isUpdated() {
        if (this.updateAware) {
            return BitOperationUtils.getBit((byte[])this.buf, (int)this.tupleStartOff, (byte)6);
        }
        return false;
    }
}

