/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl;

import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.MultiObjectDeleteException;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3a.AWSS3IOException;
import org.apache.hadoop.fs.s3a.Tristate;
import org.apache.hadoop.fs.s3a.impl.AbstractStoreOperation;
import org.apache.hadoop.fs.s3a.impl.StoreContext;
import org.apache.hadoop.fs.s3a.s3guard.BulkOperationState;
import org.apache.hadoop.fs.s3a.s3guard.MetadataStore;
import org.apache.hadoop.fs.s3a.s3guard.PathMetadata;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MultiObjectDeleteSupport
extends AbstractStoreOperation {
    private static final Logger LOG = LoggerFactory.getLogger(MultiObjectDeleteSupport.class);
    private final BulkOperationState operationState;
    public static final String ACCESS_DENIED = "AccessDenied";

    public MultiObjectDeleteSupport(StoreContext context, BulkOperationState operationState) {
        super(context);
        this.operationState = operationState;
    }

    public static IOException translateDeleteException(String message, MultiObjectDeleteException deleteException) {
        List errors = deleteException.getErrors();
        LOG.warn("Bulk delete operation failed to delete all objects; failure count = {}", (Object)errors.size());
        StringBuilder result = new StringBuilder(errors.size() * 256);
        result.append(message).append(": ");
        String exitCode = "";
        for (MultiObjectDeleteException.DeleteError error : deleteException.getErrors()) {
            String code = error.getCode();
            String item = String.format("%s: %s%s: %s%n", code, error.getKey(), error.getVersionId() != null ? " (" + error.getVersionId() + ")" : "", error.getMessage());
            LOG.warn(item);
            result.append(item);
            if (exitCode != null && !exitCode.isEmpty() && !ACCESS_DENIED.equals(code)) continue;
            exitCode = code;
        }
        if (ACCESS_DENIED.equals(exitCode)) {
            return (IOException)new AccessDeniedException(result.toString()).initCause((Throwable)deleteException);
        }
        return new AWSS3IOException(result.toString(), (AmazonS3Exception)deleteException);
    }

    public Pair<List<KeyPath>, List<KeyPath>> splitUndeletedKeys(MultiObjectDeleteException deleteException, Collection<DeleteObjectsRequest.KeyVersion> keysToDelete) {
        LOG.debug("Processing delete failure; keys to delete count = {}; errors in exception {}; successful deletions = {}", new Object[]{keysToDelete.size(), deleteException.getErrors().size(), deleteException.getDeletedObjects().size()});
        List<KeyPath> pathsBeingDeleted = this.keysToKeyPaths(keysToDelete);
        List<KeyPath> undeleted = MultiObjectDeleteSupport.removeUndeletedPaths(deleteException, pathsBeingDeleted, this.getStoreContext()::keyToPath);
        return Pair.of(undeleted, pathsBeingDeleted);
    }

    public List<Path> keysToPaths(Collection<DeleteObjectsRequest.KeyVersion> keysToDelete) {
        return MultiObjectDeleteSupport.toPathList(this.keysToKeyPaths(keysToDelete));
    }

    public List<KeyPath> keysToKeyPaths(Collection<DeleteObjectsRequest.KeyVersion> keysToDelete) {
        return MultiObjectDeleteSupport.convertToKeyPaths(keysToDelete, this.getStoreContext()::keyToPath);
    }

    public static List<KeyPath> convertToKeyPaths(Collection<DeleteObjectsRequest.KeyVersion> keysToDelete, Function<String, Path> qualifier) {
        ArrayList<KeyPath> l = new ArrayList<KeyPath>(keysToDelete.size());
        for (DeleteObjectsRequest.KeyVersion kv : keysToDelete) {
            String key = kv.getKey();
            Path p = qualifier.apply(key);
            boolean isDir = key.endsWith("/");
            l.add(new KeyPath(key, p, isDir));
        }
        return l;
    }

    public Triple<List<Path>, List<Path>, List<Pair<Path, IOException>>> processDeleteFailure(MultiObjectDeleteException deleteException, List<DeleteObjectsRequest.KeyVersion> keysToDelete, List<Path> retainedMarkers) {
        MetadataStore metadataStore = (MetadataStore)Preconditions.checkNotNull((Object)this.getStoreContext().getMetadataStore(), (Object)"context metadatastore");
        ArrayList failures = new ArrayList();
        Pair<List<KeyPath>, List<KeyPath>> outcome = this.splitUndeletedKeys(deleteException, keysToDelete);
        List deleted = (List)outcome.getRight();
        ArrayList deletedPaths = new ArrayList();
        List undeleted = (List)outcome.getLeft();
        retainedMarkers.clear();
        List<Path> undeletedPaths = MultiObjectDeleteSupport.toPathList(undeleted);
        deleted.sort((l, r) -> r.getKey().length() - l.getKey().length());
        deleted.forEach(kp -> {
            Path path = kp.getPath();
            try {
                boolean toDelete = true;
                if (kp.isDirectoryMarker()) {
                    PathMetadata pmentry = metadataStore.get(path, true);
                    toDelete = pmentry != null && !pmentry.isDeleted() ? pmentry.getFileStatus().isEmptyDirectory() == Tristate.TRUE : false;
                }
                if (toDelete) {
                    LOG.debug("Removing deleted object from S3Guard Store {}", (Object)path);
                    metadataStore.delete(path, this.operationState);
                } else {
                    LOG.debug("Retaining S3Guard directory entry {}", (Object)path);
                    retainedMarkers.add(path);
                }
            }
            catch (IOException e) {
                LOG.warn("Failed to update S3Guard store with deletion of {}", (Object)path);
                failures.add(Pair.of((Object)path, (Object)e));
            }
            deletedPaths.add(path);
        });
        if (LOG.isDebugEnabled()) {
            undeleted.forEach(p -> LOG.debug("Deleted {}", p));
        }
        return Triple.of(undeletedPaths, deletedPaths, failures);
    }

    public static List<Path> toPathList(List<KeyPath> keyPaths) {
        return keyPaths.stream().map(KeyPath::getPath).collect(Collectors.toList());
    }

    @VisibleForTesting
    public static List<Path> extractUndeletedPaths(MultiObjectDeleteException deleteException, Function<String, Path> qualifierFn) {
        return MultiObjectDeleteSupport.toPathList(MultiObjectDeleteSupport.extractUndeletedKeyPaths(deleteException, qualifierFn));
    }

    @VisibleForTesting
    public static List<KeyPath> extractUndeletedKeyPaths(MultiObjectDeleteException deleteException, Function<String, Path> qualifierFn) {
        List errors = deleteException.getErrors();
        return errors.stream().map(error -> {
            String key = error.getKey();
            Path path = (Path)qualifierFn.apply(key);
            boolean isDir = key.endsWith("/");
            return new KeyPath(key, path, isDir);
        }).collect(Collectors.toList());
    }

    @VisibleForTesting
    static List<KeyPath> removeUndeletedPaths(MultiObjectDeleteException deleteException, Collection<KeyPath> pathsBeingDeleted, Function<String, Path> qualifier) {
        List<KeyPath> undeleted = MultiObjectDeleteSupport.extractUndeletedKeyPaths(deleteException, qualifier);
        for (KeyPath undel : undeleted) {
            pathsBeingDeleted.removeIf(kp -> kp.getPath().equals((Object)undel.getPath()));
        }
        return undeleted;
    }

    public List<Path> processDeleteFailureGenericException(Exception ex, List<DeleteObjectsRequest.KeyVersion> keysToDelete) {
        return this.keysToPaths(keysToDelete);
    }

    public static final class KeyPath {
        private final String key;
        private final Path path;
        private final boolean directoryMarker;

        public KeyPath(String key, Path path, boolean directoryMarker) {
            this.key = key;
            this.path = path;
            this.directoryMarker = directoryMarker;
        }

        public String getKey() {
            return this.key;
        }

        public Path getPath() {
            return this.path;
        }

        public boolean isDirectoryMarker() {
            return this.directoryMarker;
        }

        public String toString() {
            return "KeyPath{key='" + this.key + '\'' + ", path=" + this.path + ", directoryMarker=" + this.directoryMarker + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KeyPath keyPath = (KeyPath)o;
            return this.key.equals(keyPath.key);
        }

        public int hashCode() {
            return Objects.hash(this.key);
        }
    }
}

