/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.union;

import java.nio.ByteBuffer;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.ActivityId;
import org.apache.hyracks.api.dataflow.IActivity;
import org.apache.hyracks.api.dataflow.IActivityGraphBuilder;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.dataflow.std.base.AbstractActivityNode;
import org.apache.hyracks.dataflow.std.base.AbstractOperatorDescriptor;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryOutputOperatorNodePushable;

public class UnionAllOperatorDescriptor
extends AbstractOperatorDescriptor {
    private static final long serialVersionUID = 1L;

    public UnionAllOperatorDescriptor(IOperatorDescriptorRegistry spec, int nInputs, RecordDescriptor recordDescriptor) {
        super(spec, nInputs, 1);
        this.outRecDescs[0] = recordDescriptor;
    }

    public void contributeActivities(IActivityGraphBuilder builder) {
        UnionActivityNode uba = new UnionActivityNode(new ActivityId(this.getOperatorId(), 0));
        builder.addActivity((IOperatorDescriptor)this, (IActivity)uba);
        for (int i = 0; i < this.inputArity; ++i) {
            builder.addSourceEdge(i, (IActivity)uba, i);
        }
        builder.addTargetEdge(0, (IActivity)uba, 0);
    }

    private class UnionActivityNode
    extends AbstractActivityNode {
        private static final long serialVersionUID = 1L;

        public UnionActivityNode(ActivityId id) {
            super(id);
        }

        public IOperatorNodePushable createPushRuntime(IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, int partition, int nPartitions) throws HyracksDataException {
            return new UnionOperator();
        }
    }

    private class UnionOperator
    extends AbstractUnaryOutputOperatorNodePushable {
        private int nOpened = 0;
        private int nClosed = 0;
        private boolean failed;

        private UnionOperator() {
        }

        public int getInputArity() {
            return UnionAllOperatorDescriptor.this.inputArity;
        }

        public IFrameWriter getInputFrameWriter(int index) {
            return new IFrameWriter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void open() throws HyracksDataException {
                    UnionOperator unionOperator = UnionOperator.this;
                    synchronized (unionOperator) {
                        if (++UnionOperator.this.nOpened == 1) {
                            UnionOperator.this.writer.open();
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                    UnionOperator unionOperator = UnionOperator.this;
                    synchronized (unionOperator) {
                        if (!UnionOperator.this.failed) {
                            UnionOperator.this.writer.nextFrame(buffer);
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void fail() throws HyracksDataException {
                    UnionOperator unionOperator = UnionOperator.this;
                    synchronized (unionOperator) {
                        if (!UnionOperator.this.failed) {
                            UnionOperator.this.failed = true;
                            UnionOperator.this.writer.fail();
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void close() throws HyracksDataException {
                    UnionOperator unionOperator = UnionOperator.this;
                    synchronized (unionOperator) {
                        if (++UnionOperator.this.nClosed == UnionAllOperatorDescriptor.this.inputArity) {
                            UnionOperator.this.writer.close();
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void flush() throws HyracksDataException {
                    UnionOperator unionOperator = UnionOperator.this;
                    synchronized (unionOperator) {
                        UnionOperator.this.writer.flush();
                    }
                }
            };
        }
    }
}

