/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hyracks.api.application.INCServiceContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IJsonSerializable;
import org.apache.hyracks.api.io.IPersistedResourceRegistry;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicy;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicyFactory;
import org.apache.hyracks.storage.am.lsm.common.impls.ConcurrentMergePolicy;

public class ConcurrentMergePolicyFactory
implements ILSMMergePolicyFactory {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "concurrent";
    public static final String MIN_MERGE_COMPONENT_COUNT = "min-merge-component-count";
    public static final String MAX_MERGE_COMPONENT_COUNT = "max-merge-component-count";
    public static final String MAX_COMPONENT_COUNT = "max-component-count";
    public static final String SIZE_RATIO = "size-ratio";
    public static final Set<String> PROPERTIES_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("min-merge-component-count", "max-merge-component-count", "max-component-count", "size-ratio")));

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Set<String> getPropertiesNames() {
        return PROPERTIES_NAMES;
    }

    @Override
    public ILSMMergePolicy createMergePolicy(Map<String, String> configuration, INCServiceContext ctx) {
        ConcurrentMergePolicy policy = new ConcurrentMergePolicy();
        policy.configure(configuration);
        return policy;
    }

    public JsonNode toJson(IPersistedResourceRegistry registry) throws HyracksDataException {
        return registry.getClassIdentifier(this.getClass(), 1L);
    }

    public static IJsonSerializable fromJson(IPersistedResourceRegistry registry, JsonNode json) {
        return new ConcurrentMergePolicyFactory();
    }
}

