/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.asterix.metadata.MetadataCache;
import org.apache.asterix.metadata.api.IMetadataEntity;

public class NodeGroup
implements IMetadataEntity<NodeGroup> {
    private static final long serialVersionUID = 1L;
    private final String groupName;
    private final List<String> nodeNames;

    public NodeGroup(String groupName, List<String> nodeNames) {
        this.groupName = groupName;
        this.nodeNames = nodeNames;
    }

    public static NodeGroup createOrdered(String groupName, Collection<String> nodeNames) {
        ArrayList<String> sortedNodeNames = new ArrayList<String>(nodeNames);
        Collections.sort(sortedNodeNames);
        return new NodeGroup(groupName, sortedNodeNames);
    }

    public String getNodeGroupName() {
        return this.groupName;
    }

    public List<String> getNodeNames() {
        return Collections.unmodifiableList(new ArrayList<String>(this.nodeNames));
    }

    @Override
    public NodeGroup addToCache(MetadataCache cache) {
        return cache.addOrUpdateNodeGroup(this);
    }

    @Override
    public NodeGroup dropFromCache(MetadataCache cache) {
        return cache.dropNodeGroup(this);
    }
}

