/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.utils;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.asterix.common.api.IMetadataLockManager;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.metadata.IMetadataLockUtil;
import org.apache.asterix.common.metadata.LockList;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;

public class MetadataLockUtil
implements IMetadataLockUtil {
    public void createDataverseBegin(IMetadataLockManager lockMgr, LockList locks, DataverseName dataverseName) throws AlgebricksException {
        lockMgr.acquireDataverseReadLock(locks, dataverseName);
    }

    public void dropDataverseBegin(IMetadataLockManager lockMgr, LockList locks, DataverseName dataverseName) throws AlgebricksException {
        lockMgr.acquireDataverseWriteLock(locks, dataverseName);
    }

    public void createDatasetBegin(IMetadataLockManager lockMgr, LockList locks, DataverseName dataverseName, String datasetName, DataverseName itemTypeDataverseName, String itemTypeName, boolean itemTypeAnonymous, DataverseName metaItemTypeDataverseName, String metaItemTypeName, boolean metaItemTypeAnonymous, String nodeGroupName, String compactionPolicyName, boolean isDefaultCompactionPolicy, DatasetConfig.DatasetType datasetType, Object datasetDetails) throws AlgebricksException {
        this.createDatasetBeginPre(lockMgr, locks, dataverseName, itemTypeDataverseName, itemTypeName, itemTypeAnonymous, metaItemTypeDataverseName, metaItemTypeName, metaItemTypeAnonymous, nodeGroupName, compactionPolicyName, isDefaultCompactionPolicy);
        lockMgr.acquireDatasetWriteLock(locks, dataverseName, datasetName);
    }

    protected final void createDatasetBeginPre(IMetadataLockManager lockMgr, LockList locks, DataverseName dataverseName, DataverseName itemTypeDataverseName, String itemTypeName, boolean itemTypeAnonymous, DataverseName metaItemTypeDataverseName, String metaItemTypeName, boolean metaItemTypeAnonymous, String nodeGroupName, String compactionPolicyName, boolean isDefaultCompactionPolicy) throws AlgebricksException {
        lockMgr.acquireDataverseReadLock(locks, dataverseName);
        if (itemTypeDataverseName != null && !dataverseName.equals((Object)itemTypeDataverseName)) {
            lockMgr.acquireDataverseReadLock(locks, itemTypeDataverseName);
        }
        if (metaItemTypeDataverseName != null && !metaItemTypeDataverseName.equals((Object)dataverseName) && !metaItemTypeDataverseName.equals((Object)itemTypeDataverseName)) {
            lockMgr.acquireDataverseReadLock(locks, metaItemTypeDataverseName);
        }
        if (itemTypeAnonymous) {
            lockMgr.acquireDataTypeWriteLock(locks, itemTypeDataverseName, itemTypeName);
        } else {
            lockMgr.acquireDataTypeReadLock(locks, itemTypeDataverseName, itemTypeName);
        }
        if (metaItemTypeDataverseName != null && !metaItemTypeDataverseName.equals((Object)itemTypeDataverseName) && !metaItemTypeName.equals(itemTypeName)) {
            if (metaItemTypeAnonymous) {
                lockMgr.acquireDataTypeWriteLock(locks, metaItemTypeDataverseName, metaItemTypeName);
            } else {
                lockMgr.acquireDataTypeReadLock(locks, metaItemTypeDataverseName, metaItemTypeName);
            }
        }
        if (nodeGroupName != null) {
            lockMgr.acquireNodeGroupReadLock(locks, nodeGroupName);
        }
        if (!isDefaultCompactionPolicy) {
            lockMgr.acquireMergePolicyReadLock(locks, compactionPolicyName);
        }
    }

    public void createIndexBegin(IMetadataLockManager lockMgr, LockList locks, DataverseName dataverseName, String datasetName, String fullTextConfigName) throws AlgebricksException {
        lockMgr.acquireDataverseReadLock(locks, dataverseName);
        lockMgr.acquireDatasetCreateIndexLock(locks, dataverseName, datasetName);
        if (!Strings.isNullOrEmpty((String)fullTextConfigName)) {
            lockMgr.acquireFullTextConfigReadLock(locks, dataverseName, fullTextConfigName);
        }
    }

    public void dropIndexBegin(IMetadataLockManager lockMgr, LockList locks, DataverseName dataverseName, String datasetName) throws AlgebricksException {
        lockMgr.acquireDataverseReadLock(locks, dataverseName);
        lockMgr.acquireDatasetWriteLock(locks, dataverseName, datasetName);
    }

    public void createTypeBegin(IMetadataLockManager lockMgr, LockList locks, DataverseName dataverseName, String typeName) throws AlgebricksException {
        lockMgr.acquireDataverseReadLock(locks, dataverseName);
        lockMgr.acquireDataTypeWriteLock(locks, dataverseName, typeName);
    }

    public void dropDatasetBegin(IMetadataLockManager lockMgr, LockList locks, DataverseName dataverseName, String datasetName) throws AlgebricksException {
        lockMgr.acquireDataverseReadLock(locks, dataverseName);
        lockMgr.acquireDatasetWriteLock(locks, dataverseName, datasetName);
    }

    public void dropTypeBegin(IMetadataLockManager lockMgr, LockList locks, DataverseName dataverseName, String typeName) throws AlgebricksException {
        lockMgr.acquireDataverseReadLock(locks, dataverseName);
        lockMgr.acquireDataTypeWriteLock(locks, dataverseName, typeName);
    }

    public void createLibraryBegin(IMetadataLockManager lockMgr, LockList locks, DataverseName dataverseName, String libraryName) throws AlgebricksException {
        lockMgr.acquireDataverseReadLock(locks, dataverseName);
        lockMgr.acquireLibraryWriteLock(locks, dataverseName, libraryName);
    }

    public void dropLibraryBegin(IMetadataLockManager lockMgr, LockList locks, DataverseName dataverseName, String libraryName) throws AlgebricksException {
        lockMgr.acquireDataverseReadLock(locks, dataverseName);
        lockMgr.acquireLibraryWriteLock(locks, dataverseName, libraryName);
    }

    public void createFunctionBegin(IMetadataLockManager lockMgr, LockList locks, DataverseName dataverseName, String functionName, DataverseName libraryDataverseName, String libraryName) throws AlgebricksException {
        lockMgr.acquireDataverseReadLock(locks, dataverseName);
        lockMgr.acquireFunctionWriteLock(locks, dataverseName, functionName);
        if (libraryName != null) {
            if (!dataverseName.equals((Object)libraryDataverseName)) {
                lockMgr.acquireDataverseReadLock(locks, libraryDataverseName);
            }
            lockMgr.acquireLibraryReadLock(locks, libraryDataverseName, libraryName);
        }
    }

    public void dropFunctionBegin(IMetadataLockManager lockMgr, LockList locks, DataverseName dataverseName, String functionName) throws AlgebricksException {
        lockMgr.acquireDataverseReadLock(locks, dataverseName);
        lockMgr.acquireFunctionWriteLock(locks, dataverseName, functionName);
    }

    public void createFullTextFilterBegin(IMetadataLockManager lockMgr, LockList locks, DataverseName dataverseName, String fullTextFilterName) throws AlgebricksException {
        lockMgr.acquireDataverseReadLock(locks, dataverseName);
        lockMgr.acquireFullTextFilterWriteLock(locks, dataverseName, fullTextFilterName);
    }

    public void dropFullTextFilterBegin(IMetadataLockManager lockMgr, LockList locks, DataverseName dataverseName, String fullTextFilterName) throws AlgebricksException {
        lockMgr.acquireDataverseReadLock(locks, dataverseName);
        lockMgr.acquireFullTextFilterWriteLock(locks, dataverseName, fullTextFilterName);
    }

    public void createFullTextConfigBegin(IMetadataLockManager lockMgr, LockList locks, DataverseName dataverseName, String fullTextConfigName, ImmutableList<String> fullTextFilterNames) throws AlgebricksException {
        lockMgr.acquireDataverseReadLock(locks, dataverseName);
        lockMgr.acquireFullTextConfigWriteLock(locks, dataverseName, fullTextConfigName);
        ArrayList<String> fullTextFilterNamesMutable = new ArrayList<String>((Collection<String>)fullTextFilterNames);
        Collections.sort(fullTextFilterNamesMutable);
        for (String filterName : fullTextFilterNamesMutable) {
            lockMgr.acquireFullTextFilterReadLock(locks, dataverseName, filterName);
        }
    }

    public void dropFullTextConfigBegin(IMetadataLockManager lockMgr, LockList locks, DataverseName dataverseName, String configName) throws AlgebricksException {
        lockMgr.acquireDataverseReadLock(locks, dataverseName);
        lockMgr.acquireFullTextConfigWriteLock(locks, dataverseName, configName);
    }

    public void createAdapterBegin(IMetadataLockManager lockMgr, LockList locks, DataverseName dataverseName, String adapterName, DataverseName libraryDataverseName, String libraryName) throws AlgebricksException {
        lockMgr.acquireDataverseReadLock(locks, dataverseName);
        lockMgr.acquireAdapterWriteLock(locks, dataverseName, adapterName);
        if (libraryName != null) {
            if (!dataverseName.equals((Object)libraryDataverseName)) {
                lockMgr.acquireDataverseReadLock(locks, libraryDataverseName);
            }
            lockMgr.acquireLibraryReadLock(locks, libraryDataverseName, libraryName);
        }
    }

    public void dropAdapterBegin(IMetadataLockManager lockMgr, LockList locks, DataverseName dataverseName, String adapterName) throws AlgebricksException {
        lockMgr.acquireDataverseReadLock(locks, dataverseName);
        lockMgr.acquireAdapterWriteLock(locks, dataverseName, adapterName);
    }

    public void createSynonymBegin(IMetadataLockManager lockMgr, LockList locks, DataverseName dataverseName, String synonymName) throws AlgebricksException {
        lockMgr.acquireDataverseReadLock(locks, dataverseName);
        lockMgr.acquireSynonymWriteLock(locks, dataverseName, synonymName);
    }

    public void dropSynonymBegin(IMetadataLockManager lockMgr, LockList locks, DataverseName dataverseName, String synonymName) throws AlgebricksException {
        lockMgr.acquireDataverseReadLock(locks, dataverseName);
        lockMgr.acquireSynonymWriteLock(locks, dataverseName, synonymName);
    }

    public void modifyDatasetBegin(IMetadataLockManager lockMgr, LockList locks, DataverseName dataverseName, String datasetName) throws AlgebricksException {
        lockMgr.acquireDataverseReadLock(locks, dataverseName);
        lockMgr.acquireDatasetModifyLock(locks, dataverseName, datasetName);
    }

    public void insertDeleteUpsertBegin(IMetadataLockManager lockMgr, LockList locks, DataverseName dataverseName, String datasetName) throws AlgebricksException {
        lockMgr.acquireDataverseReadLock(locks, dataverseName);
        lockMgr.acquireDatasetModifyLock(locks, dataverseName, datasetName);
    }

    public void dropFeedBegin(IMetadataLockManager lockMgr, LockList locks, DataverseName dataverseName, String feedName) throws AlgebricksException {
        lockMgr.acquireDataverseReadLock(locks, dataverseName);
        lockMgr.acquireActiveEntityWriteLock(locks, dataverseName, feedName);
    }

    public void dropFeedPolicyBegin(IMetadataLockManager lockMgr, LockList locks, DataverseName dataverseName, String policyName) throws AlgebricksException {
        lockMgr.acquireDataverseReadLock(locks, dataverseName);
        lockMgr.acquireActiveEntityWriteLock(locks, dataverseName, policyName);
    }

    public void startFeedBegin(IMetadataLockManager lockMgr, LockList locks, DataverseName dataverseName, String feedName) throws AlgebricksException {
        lockMgr.acquireDataverseReadLock(locks, dataverseName);
        lockMgr.acquireActiveEntityReadLock(locks, dataverseName, feedName);
    }

    public void stopFeedBegin(IMetadataLockManager lockMgr, LockList locks, DataverseName dataverseName, String feedName) throws AlgebricksException {
        lockMgr.acquireDataverseReadLock(locks, dataverseName);
        lockMgr.acquireActiveEntityReadLock(locks, dataverseName, feedName);
    }

    public void createFeedBegin(IMetadataLockManager lockMgr, LockList locks, DataverseName dataverseName, String feedName) throws AlgebricksException {
        lockMgr.acquireDataverseReadLock(locks, dataverseName);
        lockMgr.acquireActiveEntityWriteLock(locks, dataverseName, feedName);
    }

    public void connectFeedBegin(IMetadataLockManager lockMgr, LockList locks, DataverseName dataverseName, String datasetName, String feedName) throws AlgebricksException {
        lockMgr.acquireDataverseReadLock(locks, dataverseName);
        lockMgr.acquireActiveEntityReadLock(locks, dataverseName, feedName);
        lockMgr.acquireDatasetReadLock(locks, dataverseName, datasetName);
    }

    public void createFeedPolicyBegin(IMetadataLockManager lockMgr, LockList locks, DataverseName dataverseName, String policyName) throws AlgebricksException {
        lockMgr.acquireDataverseReadLock(locks, dataverseName);
        lockMgr.acquireFeedPolicyWriteLock(locks, dataverseName, policyName);
    }

    public void disconnectFeedBegin(IMetadataLockManager lockMgr, LockList locks, DataverseName dataverseName, String datasetName, String feedName) throws AlgebricksException {
        lockMgr.acquireDataverseReadLock(locks, dataverseName);
        lockMgr.acquireActiveEntityReadLock(locks, dataverseName, feedName);
        lockMgr.acquireDatasetReadLock(locks, dataverseName, datasetName);
    }

    public void analyzeDatasetBegin(IMetadataLockManager lockMgr, LockList locks, DataverseName dataverseName, String datasetName) throws AlgebricksException {
        lockMgr.acquireDataverseReadLock(locks, dataverseName);
        lockMgr.acquireDatasetCreateIndexLock(locks, dataverseName, datasetName);
    }

    public void analyzeDatasetDropBegin(IMetadataLockManager lockMgr, LockList locks, DataverseName dataverseName, String datasetName) throws AlgebricksException {
        lockMgr.acquireDataverseReadLock(locks, dataverseName);
        lockMgr.acquireDatasetWriteLock(locks, dataverseName, datasetName);
    }

    public void compactBegin(IMetadataLockManager lockMgr, LockList locks, DataverseName dataverseName, String datasetName) throws AlgebricksException {
        lockMgr.acquireDataverseReadLock(locks, dataverseName);
        lockMgr.acquireDatasetReadLock(locks, dataverseName, datasetName);
    }

    public void refreshDatasetBegin(IMetadataLockManager lockMgr, LockList locks, DataverseName dataverseName, String datasetName) throws AlgebricksException {
        lockMgr.acquireDataverseReadLock(locks, dataverseName);
        lockMgr.acquireDatasetExclusiveModificationLock(locks, dataverseName, datasetName);
    }
}

