/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.gcs;

import com.google.cloud.BaseServiceException;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.Storage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPInputStream;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.external.input.record.reader.abstracts.AbstractExternalInputStream;
import org.apache.asterix.external.util.ExternalDataConstants;
import org.apache.asterix.external.util.google.gcs.GCSUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.util.CleanupUtils;
import org.apache.hyracks.api.util.ExceptionUtils;
import org.apache.hyracks.util.LogRedactionUtil;

public class GCSInputStream
extends AbstractExternalInputStream {
    private final Storage client;
    private final String container;
    private static final int MAX_ATTEMPTS = 5;

    public GCSInputStream(Map<String, String> configuration, List<String> filePaths) throws HyracksDataException {
        super(configuration, filePaths);
        this.client = this.buildClient(configuration);
        this.container = configuration.get("container");
    }

    @Override
    protected boolean getInputStream() throws IOException {
        String fileName = (String)this.filePaths.get(this.nextFileIndex);
        if (!this.doGetInputStream(fileName)) {
            return false;
        }
        if (StringUtils.endsWithIgnoreCase((CharSequence)fileName, (CharSequence)".gz") || StringUtils.endsWithIgnoreCase((CharSequence)fileName, (CharSequence)".gzip")) {
            this.in = new GZIPInputStream(this.in, ExternalDataConstants.DEFAULT_BUFFER_SIZE);
        }
        return true;
    }

    private boolean doGetInputStream(String fileName) throws RuntimeDataException {
        int attempt = 0;
        BlobId blobId = BlobId.of((String)this.container, (String)fileName);
        while (attempt < 5) {
            try {
                Blob blob = this.client.get(blobId);
                if (blob == null) {
                    LOGGER.debug(() -> "Key " + LogRedactionUtil.userData((String)fileName) + " was not found in container " + this.container);
                    return false;
                }
                this.in = new ByteArrayInputStream(blob.getContent(new Blob.BlobSourceOption[0]));
                break;
            }
            catch (BaseServiceException ex) {
                if (!ex.isRetryable() || !this.shouldRetry(++attempt)) {
                    throw new RuntimeDataException(ErrorCode.EXTERNAL_SOURCE_ERROR, new Serializable[]{ExceptionUtils.getMessageOrToString((Throwable)ex)});
                }
                LOGGER.debug(() -> "Retryable error: " + ExceptionUtils.getMessageOrToString((Throwable)ex));
                try {
                    Thread.sleep(TimeUnit.SECONDS.toMillis(attempt < 3 ? 1L : 2L));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            catch (Exception ex) {
                throw new RuntimeDataException(ErrorCode.EXTERNAL_SOURCE_ERROR, new Serializable[]{ExceptionUtils.getMessageOrToString((Throwable)ex)});
            }
        }
        return true;
    }

    private boolean shouldRetry(int nextAttempt) {
        return nextAttempt < 5;
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            CleanupUtils.close((AutoCloseable)this.in, null);
        }
    }

    @Override
    public boolean stop() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private Storage buildClient(Map<String, String> configuration) throws HyracksDataException {
        try {
            return GCSUtils.buildClient(configuration);
        }
        catch (CompilationException ex) {
            throw HyracksDataException.create((Throwable)ex);
        }
    }
}

