/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.data.std.util;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.util.ISequenceIterator;
import org.apache.hyracks.util.string.UTF8StringUtil;

public class UTF8StringCharByCharIterator
implements ISequenceIterator {
    protected byte[] data;
    protected int pos = -1;
    protected int length = -1;
    protected int utfByteLength = -1;
    protected int metaLength = -1;
    protected int startOffset = -1;

    @Override
    public int compare(ISequenceIterator cmpIter) throws HyracksDataException {
        char thatChar;
        char thisChar = Character.toLowerCase(UTF8StringUtil.charAt((byte[])this.data, (int)this.pos));
        if (thisChar == (thatChar = Character.toLowerCase(UTF8StringUtil.charAt((byte[])cmpIter.getData(), (int)cmpIter.getPos())))) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean hasNext() {
        return this.pos < this.utfByteLength;
    }

    @Override
    public int size() {
        return this.length;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public int getPos() {
        return this.pos;
    }

    @Override
    public void next() throws HyracksDataException {
        this.pos += UTF8StringUtil.charSize((byte[])this.data, (int)this.pos);
    }

    @Override
    public void reset() throws HyracksDataException {
        this.pos = this.startOffset + this.metaLength;
    }

    @Override
    public void reset(byte[] data, int startOff) throws HyracksDataException {
        this.data = data;
        this.startOffset = startOff;
        this.length = UTF8StringUtil.getStringLength((byte[])data, (int)this.startOffset);
        this.utfByteLength = UTF8StringUtil.getUTFLength((byte[])data, (int)this.startOffset);
        this.metaLength = UTF8StringUtil.getNumBytesToStoreLength((int)this.utfByteLength);
        this.reset();
    }
}

