/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.api.http.server;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import javax.imageio.ImageIO;
import org.apache.asterix.api.http.server.ResultUtil;
import org.apache.asterix.api.http.server.ServletUtil;
import org.apache.asterix.app.result.ResponsePrinter;
import org.apache.asterix.app.translator.RequestParameters;
import org.apache.asterix.common.api.IApplicationContext;
import org.apache.asterix.common.api.IRequestReference;
import org.apache.asterix.common.api.IResponsePrinter;
import org.apache.asterix.common.config.GlobalConfig;
import org.apache.asterix.common.context.IStorageComponentProvider;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.compiler.provider.ILangCompilationProvider;
import org.apache.asterix.lang.common.base.IParser;
import org.apache.asterix.lang.common.base.IParserFactory;
import org.apache.asterix.lang.sqlpp.parser.TokenMgrError;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.translator.IRequestParameters;
import org.apache.asterix.translator.IStatementExecutor;
import org.apache.asterix.translator.IStatementExecutorFactory;
import org.apache.asterix.translator.ResultProperties;
import org.apache.asterix.translator.SessionConfig;
import org.apache.asterix.translator.SessionOutput;
import org.apache.hyracks.api.client.IHyracksClientConnection;
import org.apache.hyracks.api.result.IResultSet;
import org.apache.hyracks.http.api.IServletRequest;
import org.apache.hyracks.http.api.IServletResponse;
import org.apache.hyracks.http.server.AbstractServlet;
import org.apache.hyracks.http.server.StaticResourceServlet;
import org.apache.hyracks.http.server.utils.HttpUtil;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ApiServlet
extends AbstractServlet {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String HTML_STATEMENT_SEPARATOR = "<!-- BEGIN -->";
    private final ICcApplicationContext appCtx;
    private final ILangCompilationProvider sqlppCompilationProvider;
    private final IStatementExecutorFactory statementExectorFactory;
    private final IStorageComponentProvider componentProvider;

    public ApiServlet(ConcurrentMap<String, Object> ctx, String[] paths, ICcApplicationContext appCtx, ILangCompilationProvider sqlppCompilationProvider, IStatementExecutorFactory statementExecutorFactory, IStorageComponentProvider componentProvider) {
        super(ctx, paths);
        this.appCtx = appCtx;
        this.sqlppCompilationProvider = sqlppCompilationProvider;
        this.statementExectorFactory = statementExecutorFactory;
        this.componentProvider = componentProvider;
    }

    protected void post(IServletRequest request, IServletResponse response) {
        SessionConfig.OutputFormat format;
        IRequestReference requestReference = this.appCtx.getReceptionist().welcome(request);
        ILangCompilationProvider compilationProvider = this.sqlppCompilationProvider;
        IParserFactory parserFactory = compilationProvider.getParserFactory();
        try {
            HttpUtil.setContentType((IServletResponse)response, (String)"text/html", (IServletRequest)request);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARN, "Failure setting content type", (Throwable)e);
            response.setStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR);
            return;
        }
        PrintWriter out = response.writer();
        boolean csvAndHeader = false;
        String output = request.getParameter((CharSequence)"output-format");
        if ("CSV-Header".equals(output)) {
            output = "CSV";
            csvAndHeader = true;
        }
        try {
            format = SessionConfig.OutputFormat.valueOf((String)output);
        }
        catch (IllegalArgumentException e) {
            LOGGER.log(Level.INFO, output + ": unsupported output-format, using " + SessionConfig.OutputFormat.CLEAN_JSON + " instead", (Throwable)e);
            format = SessionConfig.OutputFormat.CLEAN_JSON;
        }
        SessionConfig.PlanFormat planFormat = SessionConfig.PlanFormat.get((String)request.getParameter((CharSequence)"plan-format"), (String)"plan format", (SessionConfig.PlanFormat)SessionConfig.PlanFormat.STRING, (Logger)LOGGER);
        String query = request.getParameter((CharSequence)"query");
        String wrapperArray = request.getParameter((CharSequence)"wrapper-array");
        String printExprParam = request.getParameter((CharSequence)"print-expr-tree");
        String printRewrittenExprParam = request.getParameter((CharSequence)"print-rewritten-expr-tree");
        String printLogicalPlanParam = request.getParameter((CharSequence)"print-logical-plan");
        String printOptimizedLogicalPlanParam = request.getParameter((CharSequence)"print-optimized-logical-plan");
        String printJob = request.getParameter((CharSequence)"print-job");
        String executeQuery = request.getParameter((CharSequence)"execute-query");
        response.setStatus(HttpResponseStatus.OK);
        try {
            IHyracksClientConnection hcc = (IHyracksClientConnection)this.ctx.get("org.apache.asterix.HYRACKS_CONNECTION");
            IResultSet resultSet = ServletUtil.getResultSet(hcc, (IApplicationContext)this.appCtx, this.ctx);
            IParser parser = parserFactory.createParser(query);
            List statements = parser.parse();
            SessionConfig sessionConfig = new SessionConfig(format, true, ApiServlet.isSet(executeQuery), true, planFormat);
            sessionConfig.set("format-html", true);
            sessionConfig.set("format-csv-header", csvAndHeader);
            sessionConfig.set("format-wrapper-array", ApiServlet.isSet(wrapperArray));
            sessionConfig.setOOBData(ApiServlet.isSet(printExprParam), ApiServlet.isSet(printRewrittenExprParam), ApiServlet.isSet(printLogicalPlanParam), ApiServlet.isSet(printOptimizedLogicalPlanParam), ApiServlet.isSet(printJob));
            SessionOutput sessionOutput = new SessionOutput(sessionConfig, out);
            MetadataManager.INSTANCE.init();
            IStatementExecutor translator = this.statementExectorFactory.create(this.appCtx, statements, sessionOutput, compilationProvider, this.componentProvider, (IResponsePrinter)new ResponsePrinter(sessionOutput));
            long startTime = System.currentTimeMillis();
            RequestParameters requestParameters = new RequestParameters(requestReference, query, resultSet, new ResultProperties(IStatementExecutor.ResultDelivery.IMMEDIATE), new IStatementExecutor.Stats(), new IStatementExecutor.StatementProperties(), null, null, null, null, null, true);
            translator.compileAndExecute(hcc, (IRequestParameters)requestParameters);
            long endTime = System.currentTimeMillis();
            double duration = (double)(endTime - startTime) / 1000.0;
            out.println(HTML_STATEMENT_SEPARATOR);
            out.println("<PRE>Duration of all jobs: " + duration + " sec</PRE>");
        }
        catch (AsterixException | TokenMgrError pe) {
            GlobalConfig.ASTERIX_LOGGER.log(Level.INFO, pe.toString(), pe);
            ResultUtil.webUIParseExceptionHandler(out, pe, query);
        }
        catch (Exception e) {
            GlobalConfig.ASTERIX_LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            ResultUtil.webUIErrorHandler(out, e);
        }
    }

    protected void get(IServletRequest request, IServletResponse response) {
        String resourcePath = null;
        String requestURI = request.getHttpRequest().uri();
        response.setStatus(HttpResponseStatus.OK);
        if ("/".equals(requestURI)) {
            try {
                HttpUtil.setContentType((IServletResponse)response, (String)"text/html", (IServletRequest)request);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARN, "Failure setting content type", (Throwable)e);
                response.setStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR);
                return;
            }
            resourcePath = "/webui/querytemplate.html";
        } else {
            resourcePath = requestURI;
        }
        try (InputStream is = ApiServlet.class.getResourceAsStream(resourcePath);){
            if (is == null) {
                response.setStatus(HttpResponseStatus.NOT_FOUND);
                return;
            }
            if (resourcePath.endsWith(".png")) {
                BufferedImage img = ImageIO.read(is);
                HttpUtil.setContentType((IServletResponse)response, (String)"image/png");
                OutputStream outputStream = response.outputStream();
                String formatName = "png";
                ImageIO.write((RenderedImage)img, formatName, outputStream);
                outputStream.close();
                return;
            }
            String type = HttpUtil.mime((String)StaticResourceServlet.extension((String)resourcePath));
            HttpUtil.setContentType((IServletResponse)response, (String)("".equals(type) ? "text/plain" : type), (Charset)StandardCharsets.UTF_8);
            this.writeOutput(response, is, resourcePath);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARN, "Failure handling request", (Throwable)e);
            response.setStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private void writeOutput(IServletResponse response, InputStream is, String resourcePath) throws IOException {
        InputStreamReader isr = new InputStreamReader(is);
        try {
            BufferedReader br = new BufferedReader(isr);
            try {
                String line;
                StringBuilder sb = new StringBuilder();
                try {
                    line = br.readLine();
                }
                catch (NullPointerException e) {
                    LOGGER.log(Level.WARN, "NPE reading resource " + resourcePath + ", assuming JDK-8080094; returning 404", (Throwable)e);
                    response.setStatus(HttpResponseStatus.NOT_FOUND);
                    br.close();
                    isr.close();
                    return;
                }
                while (line != null) {
                    sb.append(line);
                    line = br.readLine();
                }
                PrintWriter out = response.writer();
                out.println(sb.toString());
            }
            finally {
                try {
                    br.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
        finally {
            try {
                isr.close();
            }
            catch (Throwable throwable) {
                Throwable throwable3;
                throwable3.addSuppressed(throwable);
            }
        }
    }

    private static boolean isSet(String requestParameter) {
        return "true".equals(requestParameter);
    }
}

