/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.collectors;

import java.util.ArrayList;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameReader;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.INormalizedKeyComputer;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.std.collectors.IPartitionBatchManager;
import org.apache.hyracks.dataflow.std.sort.RunMergingFrameReader;

public class SortMergeFrameReader
implements IFrameReader {
    private IHyracksTaskContext ctx;
    private final int maxConcurrentMerges;
    private final int nSenders;
    private final int[] sortFields;
    private final IBinaryComparator[] comparators;
    private final INormalizedKeyComputer nmkComputer;
    private final RecordDescriptor recordDescriptor;
    private final IPartitionBatchManager pbm;
    private RunMergingFrameReader merger;

    public SortMergeFrameReader(IHyracksTaskContext ctx, int maxConcurrentMerges, int nSenders, int[] sortFields, IBinaryComparator[] comparators, INormalizedKeyComputer nmkComputer, RecordDescriptor recordDescriptor, IPartitionBatchManager pbm) {
        this.ctx = ctx;
        this.maxConcurrentMerges = maxConcurrentMerges;
        this.nSenders = nSenders;
        this.sortFields = sortFields;
        this.comparators = comparators;
        this.nmkComputer = nmkComputer;
        this.recordDescriptor = recordDescriptor;
        this.pbm = pbm;
    }

    public void open() throws HyracksDataException {
        ArrayList<VSizeFrame> inFrames;
        if (this.maxConcurrentMerges >= this.nSenders) {
            inFrames = new ArrayList<VSizeFrame>(this.nSenders);
            for (int i = 0; i < this.nSenders; ++i) {
                inFrames.add(new VSizeFrame((IHyracksFrameMgrContext)this.ctx));
            }
        } else {
            throw new HyracksDataException("Not yet supported");
        }
        ArrayList<IFrameReader> batch = new ArrayList<IFrameReader>(this.nSenders);
        this.pbm.getNextBatch(batch, this.nSenders);
        this.merger = new RunMergingFrameReader(this.ctx, batch, inFrames, this.sortFields, this.comparators, this.nmkComputer, this.recordDescriptor);
        this.merger.open();
    }

    public boolean nextFrame(IFrame frame) throws HyracksDataException {
        return this.merger.nextFrame(frame);
    }

    public void close() throws HyracksDataException {
        this.merger.close();
    }
}

