/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.functions;

import java.util.List;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;

class FunctionDisplayUtil {
    private FunctionDisplayUtil() {
    }

    public static String display(IFunctionInfo functionInfo, List<Mutable<ILogicalExpression>> args, DefaultDisplayFunction defaultDisplayFunction) {
        FunctionIdentifier funcId = functionInfo.getFunctionIdentifier();
        if (funcId.equals((Object)BuiltinFunctions.FIELD_ACCESS_BY_INDEX)) {
            return FunctionDisplayUtil.displayFieldAccess(args, true);
        }
        if (funcId.equals((Object)BuiltinFunctions.FIELD_ACCESS_BY_NAME) || funcId.equals((Object)BuiltinFunctions.FIELD_ACCESS_NESTED)) {
            return FunctionDisplayUtil.displayFieldAccess(args, false);
        }
        if (funcId.equals((Object)BuiltinFunctions.OPEN_RECORD_CONSTRUCTOR) || funcId.equals((Object)BuiltinFunctions.CLOSED_RECORD_CONSTRUCTOR)) {
            return FunctionDisplayUtil.displayRecordConstructor(args);
        }
        return defaultDisplayFunction.display(args);
    }

    private static String displayFieldAccess(List<Mutable<ILogicalExpression>> args, boolean intArg) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        boolean second = true;
        for (Mutable<ILogicalExpression> ref : args) {
            if (first) {
                first = false;
            } else if (second) {
                sb.append(".getField(" + (intArg ? "" : "\""));
                second = false;
            } else {
                sb.append(".");
            }
            sb.append(((ILogicalExpression)ref.getValue()).toString().replaceAll("^\"|\"$", ""));
        }
        sb.append((intArg ? "" : "\"") + ")");
        return sb.toString();
    }

    private static String displayRecordConstructor(List<Mutable<ILogicalExpression>> args) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        boolean fieldName = true;
        sb.append("{");
        for (Mutable<ILogicalExpression> ref : args) {
            if (first) {
                first = false;
            } else if (fieldName) {
                sb.append(", ");
            }
            sb.append(ref.getValue());
            if (fieldName) {
                sb.append(": ");
                fieldName = false;
                continue;
            }
            fieldName = true;
        }
        sb.append("}");
        return sb.toString();
    }

    @FunctionalInterface
    static interface DefaultDisplayFunction {
        public String display(List<Mutable<ILogicalExpression>> var1);
    }
}

