/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.type.kdc;

import org.apache.kerby.asn1.Asn1FieldInfo;
import org.apache.kerby.asn1.EnumType;
import org.apache.kerby.asn1.ExplicitField;
import org.apache.kerby.asn1.type.Asn1Integer;
import org.apache.kerby.asn1.type.Asn1Type;
import org.apache.kerby.kerberos.kerb.type.KerberosString;
import org.apache.kerby.kerberos.kerb.type.base.EncryptedData;
import org.apache.kerby.kerberos.kerb.type.base.KrbMessage;
import org.apache.kerby.kerberos.kerb.type.base.KrbMessageType;
import org.apache.kerby.kerberos.kerb.type.base.PrincipalName;
import org.apache.kerby.kerberos.kerb.type.kdc.EncKdcRepPart;
import org.apache.kerby.kerberos.kerb.type.pa.PaData;
import org.apache.kerby.kerberos.kerb.type.ticket.Ticket;

public class KdcRep
extends KrbMessage {
    static Asn1FieldInfo[] fieldInfos = new Asn1FieldInfo[]{new ExplicitField((EnumType)KdcRepField.PVNO, Asn1Integer.class), new ExplicitField((EnumType)KdcRepField.MSG_TYPE, Asn1Integer.class), new ExplicitField((EnumType)KdcRepField.PADATA, PaData.class), new ExplicitField((EnumType)KdcRepField.CREALM, KerberosString.class), new ExplicitField((EnumType)KdcRepField.CNAME, PrincipalName.class), new ExplicitField((EnumType)KdcRepField.TICKET, Ticket.class), new ExplicitField((EnumType)KdcRepField.ENC_PART, EncryptedData.class)};
    private EncKdcRepPart encPart;

    public KdcRep(KrbMessageType msgType) {
        super(msgType, fieldInfos);
    }

    public PaData getPaData() {
        return (PaData)this.getFieldAs(KdcRepField.PADATA, PaData.class);
    }

    public void setPaData(PaData paData) {
        this.setFieldAs(KdcRepField.PADATA, (Asn1Type)paData);
    }

    public PrincipalName getCname() {
        return (PrincipalName)this.getFieldAs(KdcRepField.CNAME, PrincipalName.class);
    }

    public void setCname(PrincipalName sname) {
        this.setFieldAs(KdcRepField.CNAME, (Asn1Type)sname);
    }

    public String getCrealm() {
        return this.getFieldAsString(KdcRepField.CREALM);
    }

    public void setCrealm(String realm) {
        this.setFieldAs(KdcRepField.CREALM, (Asn1Type)new KerberosString(realm));
    }

    public Ticket getTicket() {
        return (Ticket)this.getFieldAs(KdcRepField.TICKET, Ticket.class);
    }

    public void setTicket(Ticket ticket) {
        this.setFieldAs(KdcRepField.TICKET, (Asn1Type)ticket);
    }

    public EncryptedData getEncryptedEncPart() {
        return (EncryptedData)this.getFieldAs(KdcRepField.ENC_PART, EncryptedData.class);
    }

    public void setEncryptedEncPart(EncryptedData encryptedEncPart) {
        this.setFieldAs(KdcRepField.ENC_PART, (Asn1Type)encryptedEncPart);
    }

    public EncKdcRepPart getEncPart() {
        return this.encPart;
    }

    public void setEncPart(EncKdcRepPart encPart) {
        this.encPart = encPart;
    }

    protected static enum KdcRepField implements EnumType
    {
        PVNO,
        MSG_TYPE,
        PADATA,
        CREALM,
        CNAME,
        TICKET,
        ENC_PART;


        public int getValue() {
            return this.ordinal();
        }

        public String getName() {
            return this.name();
        }
    }
}

