/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.List;
import org.apache.iceberg.BaseTableScan;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.IncrementalDataTableScan;
import org.apache.iceberg.ManifestGroup;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.TableScanContext;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.util.SnapshotUtil;

public class DataTableScan
extends BaseTableScan {
    public DataTableScan(TableOperations ops, Table table) {
        super(ops, table, table.schema());
    }

    protected DataTableScan(TableOperations ops, Table table, Schema schema, TableScanContext context) {
        super(ops, table, schema, context);
    }

    @Override
    public TableScan appendsBetween(long fromSnapshotId, long toSnapshotId) {
        Preconditions.checkState((this.snapshotId() == null ? 1 : 0) != 0, (String)"Cannot enable incremental scan, scan-snapshot set to id=%s", (Object)this.snapshotId());
        return new IncrementalDataTableScan(this.tableOps(), this.table(), this.schema(), this.context().fromSnapshotIdExclusive(fromSnapshotId).toSnapshotId(toSnapshotId));
    }

    @Override
    public TableScan appendsAfter(long fromSnapshotId) {
        Snapshot currentSnapshot = this.table().currentSnapshot();
        Preconditions.checkState((currentSnapshot != null ? 1 : 0) != 0, (String)"Cannot scan appends after %s, there is no current snapshot", (long)fromSnapshotId);
        return this.appendsBetween(fromSnapshotId, currentSnapshot.snapshotId());
    }

    @Override
    public TableScan useSnapshot(long scanSnapshotId) {
        super.useSnapshot(scanSnapshotId);
        Schema snapshotSchema = SnapshotUtil.schemaFor(this.table(), scanSnapshotId);
        return this.newRefinedScan(this.tableOps(), this.table(), snapshotSchema, this.context().useSnapshotId(scanSnapshotId));
    }

    @Override
    protected TableScan newRefinedScan(TableOperations ops, Table table, Schema schema, TableScanContext context) {
        return new DataTableScan(ops, table, schema, context);
    }

    @Override
    public CloseableIterable<FileScanTask> doPlanFiles() {
        Snapshot snapshot = this.snapshot();
        FileIO io = this.table().io();
        List dataManifests = snapshot.dataManifests(io);
        List deleteManifests = snapshot.deleteManifests(io);
        this.scanMetrics().totalDataManifests().increment((long)dataManifests.size());
        this.scanMetrics().totalDeleteManifests().increment((long)deleteManifests.size());
        ManifestGroup manifestGroup = new ManifestGroup(io, dataManifests, deleteManifests).caseSensitive(this.isCaseSensitive()).select(this.scanColumns()).filterData(this.filter()).specsById(this.table().specs()).scanMetrics(this.scanMetrics()).ignoreDeleted();
        if (this.shouldIgnoreResiduals()) {
            manifestGroup = manifestGroup.ignoreResiduals();
        }
        if (dataManifests.size() > 1 && this.shouldPlanWithExecutor()) {
            manifestGroup = manifestGroup.planWith(this.planExecutor());
        }
        return manifestGroup.planFiles();
    }
}

