/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.statement;

import com.google.common.collect.ImmutableList;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.metadata.Namespace;
import org.apache.asterix.lang.common.base.AbstractStatement;
import org.apache.asterix.lang.common.base.Statement;
import org.apache.asterix.lang.common.expression.RecordConstructor;
import org.apache.asterix.lang.common.util.FullTextUtil;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.object.base.AdmArrayNode;
import org.apache.asterix.object.base.AdmObjectNode;
import org.apache.asterix.object.base.AdmStringNode;
import org.apache.asterix.object.base.IAdmNode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.lsm.invertedindex.fulltext.TokenizerCategory;

public class CreateFullTextConfigStatement
extends AbstractStatement {
    private final Namespace namespace;
    private final String configName;
    private final boolean ifNotExists;
    private final AdmObjectNode configNode;
    public static final String FIELD_NAME_TOKENIZER = "tokenizer";
    public static final String FIELD_NAME_FILTER_PIPELINE = "filterPipeline";

    public CreateFullTextConfigStatement(Namespace namespace, String configName, boolean ifNotExists, RecordConstructor expr) throws CompilationException {
        this.namespace = namespace;
        this.configName = configName;
        this.ifNotExists = ifNotExists;
        this.configNode = FullTextUtil.validateAndGetConfigNode(expr);
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public DataverseName getDataverseName() {
        return this.namespace == null ? null : this.namespace.getDataverseName();
    }

    public String getConfigName() {
        return this.configName;
    }

    public boolean getIfNotExists() {
        return this.ifNotExists;
    }

    @Override
    public Statement.Kind getKind() {
        return Statement.Kind.CREATE_FULL_TEXT_CONFIG;
    }

    @Override
    public <R, T> R accept(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        return visitor.visit(this, arg);
    }

    @Override
    public byte getCategory() {
        return 4;
    }

    public TokenizerCategory getTokenizerCategory() throws HyracksDataException {
        String tokenizerCategoryStr = this.configNode.getString(FIELD_NAME_TOKENIZER);
        return TokenizerCategory.getEnumIgnoreCase((String)tokenizerCategoryStr);
    }

    public ImmutableList<String> getFilterNames() {
        AdmArrayNode arrayNode = (AdmArrayNode)this.configNode.get(FIELD_NAME_FILTER_PIPELINE);
        ImmutableList.Builder filterNamesBuilder = ImmutableList.builder();
        for (IAdmNode iAdmNode : arrayNode) {
            filterNamesBuilder.add((Object)((AdmStringNode)iAdmNode).get());
        }
        return filterNamesBuilder.build();
    }
}

