/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.common.dataflow;

import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.dataflow.std.base.AbstractSingleActivityOperatorDescriptor;
import org.apache.hyracks.storage.am.common.api.IIndexBuilder;
import org.apache.hyracks.storage.am.common.api.IIndexBuilderFactory;
import org.apache.hyracks.storage.am.common.dataflow.IndexCreateOperatorNodePushable;

public class IndexCreateOperatorDescriptor
extends AbstractSingleActivityOperatorDescriptor {
    private static final long serialVersionUID = 2L;
    private final IIndexBuilderFactory[][] indexBuilderFactories;
    private final int[][] partitionsMap;

    public IndexCreateOperatorDescriptor(IOperatorDescriptorRegistry spec, IIndexBuilderFactory[][] indexBuilderFactories, int[][] partitionsMap) {
        super(spec, 0, 0);
        this.indexBuilderFactories = indexBuilderFactories;
        this.partitionsMap = partitionsMap;
    }

    public IOperatorNodePushable createPushRuntime(IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, int partition, int nPartitions) throws HyracksDataException {
        int[] storagePartitions = this.partitionsMap[partition];
        IIndexBuilderFactory[] partitionIndexBuilderFactories = this.indexBuilderFactories[partition];
        IIndexBuilder[] indexBuilders = new IIndexBuilder[storagePartitions.length];
        for (int i = 0; i < storagePartitions.length; ++i) {
            indexBuilders[i] = partitionIndexBuilderFactories[i].create(ctx, storagePartitions[i]);
        }
        return new IndexCreateOperatorNodePushable(indexBuilders);
    }
}

