/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.common.impls;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.common.api.IPageManager;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrame;
import org.apache.hyracks.storage.am.common.api.ITreeIndexMetadataFrame;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleReference;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleWriter;
import org.apache.hyracks.storage.am.common.impls.AbstractTreeIndex;
import org.apache.hyracks.storage.am.common.impls.NodeFrontier;
import org.apache.hyracks.storage.common.IIndexBulkLoader;
import org.apache.hyracks.storage.common.MultiComparator;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;
import org.apache.hyracks.storage.common.buffercache.IFIFOPageWriter;
import org.apache.hyracks.storage.common.buffercache.IPageWriteCallback;
import org.apache.hyracks.storage.common.buffercache.IPageWriteFailureCallback;
import org.apache.hyracks.storage.common.buffercache.PageWriteFailureCallback;
import org.apache.hyracks.storage.common.compression.file.ICompressedPageWriter;
import org.apache.hyracks.storage.common.file.BufferedFileHandle;

public abstract class AbstractTreeIndexBulkLoader
extends PageWriteFailureCallback
implements IIndexBulkLoader {
    protected final IBufferCache bufferCache;
    protected final IPageManager freePageManager;
    protected final AbstractTreeIndex treeIndex;
    protected final int fileId;
    protected final MultiComparator cmp;
    protected final int slotSize;
    protected final int leafMaxBytes;
    protected final int interiorMaxBytes;
    protected final ArrayList<NodeFrontier> nodeFrontiers = new ArrayList();
    protected final ITreeIndexMetadataFrame metaFrame;
    protected final ITreeIndexTupleWriter tupleWriter;
    protected ITreeIndexFrame leafFrame;
    protected ITreeIndexFrame interiorFrame;
    protected boolean releasedLatches;
    private final IFIFOPageWriter pageWriter;
    protected List<ICachedPage> pagesToWrite;
    private final ICompressedPageWriter compressedPageWriter;

    protected AbstractTreeIndexBulkLoader(float fillFactor, IPageWriteCallback callback, ITreeIndex index) throws HyracksDataException {
        this(fillFactor, callback, index, index.getLeafFrameFactory().createFrame());
    }

    protected AbstractTreeIndexBulkLoader(float fillFactor, IPageWriteCallback callback, ITreeIndex index, ITreeIndexFrame leafFrame) throws HyracksDataException {
        this.bufferCache = index.getBufferCache();
        this.freePageManager = index.getPageManager();
        this.fileId = index.getFileId();
        this.treeIndex = (AbstractTreeIndex)index;
        this.leafFrame = leafFrame;
        this.interiorFrame = this.treeIndex.getInteriorFrameFactory().createFrame();
        this.metaFrame = this.freePageManager.createMetadataFrame();
        this.pageWriter = this.bufferCache.createFIFOWriter(callback, (IPageWriteFailureCallback)this);
        if (!this.treeIndex.isEmptyTree(leafFrame)) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.CANNOT_BULK_LOAD_NON_EMPTY_TREE, (Serializable[])new Serializable[0]);
        }
        this.cmp = MultiComparator.create((IBinaryComparatorFactory[])this.treeIndex.getCmpFactories());
        leafFrame.setMultiComparator(this.cmp);
        this.interiorFrame.setMultiComparator(this.cmp);
        this.tupleWriter = leafFrame.getTupleWriter();
        NodeFrontier leafFrontier = new NodeFrontier(this.createTupleReference());
        leafFrontier.pageId = this.freePageManager.takePage(this.metaFrame);
        leafFrontier.page = this.bufferCache.confiscatePage(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)leafFrontier.pageId));
        this.interiorFrame.setPage(leafFrontier.page);
        this.interiorFrame.initBuffer((byte)0);
        this.interiorMaxBytes = (int)((float)this.interiorFrame.getBuffer().capacity() * fillFactor);
        leafFrame.setPage(leafFrontier.page);
        leafFrame.initBuffer((byte)0);
        this.leafMaxBytes = (int)((float)leafFrame.getBuffer().capacity() * fillFactor);
        this.slotSize = leafFrame.getSlotSize();
        this.nodeFrontiers.add(leafFrontier);
        this.pagesToWrite = new ArrayList<ICachedPage>();
        this.compressedPageWriter = this.bufferCache.getCompressedPageWriter(this.fileId);
    }

    protected ITreeIndexTupleReference createTupleReference() {
        return this.leafFrame.createTupleReference();
    }

    protected void handleException() {
        this.compressedPageWriter.abort();
        for (NodeFrontier nodeFrontier : this.nodeFrontiers) {
            ICachedPage frontierPage;
            if (nodeFrontier == null || nodeFrontier.page == null || !(frontierPage = nodeFrontier.page).confiscated()) continue;
            this.bufferCache.returnPage(frontierPage, false);
        }
        for (ICachedPage pageToDiscard : this.pagesToWrite) {
            if (pageToDiscard == null) continue;
            this.bufferCache.returnPage(pageToDiscard, false);
        }
        this.releasedLatches = true;
    }

    public void end() throws HyracksDataException {
        if (this.hasFailed()) {
            throw HyracksDataException.create((Throwable)this.getFailure());
        }
        this.freePageManager.setRootPageId(this.treeIndex.getRootPageId());
    }

    protected void setRootPageId(int rootPage) {
        this.treeIndex.rootPage = rootPage;
    }

    protected void addLevel() throws HyracksDataException {
        NodeFrontier frontier = new NodeFrontier(this.tupleWriter.createTupleReference());
        frontier.page = this.bufferCache.confiscatePage(-1L);
        frontier.pageId = -1;
        frontier.lastTuple.setFieldCount(this.cmp.getKeyFieldCount());
        this.interiorFrame.setPage(frontier.page);
        this.interiorFrame.initBuffer((byte)this.nodeFrontiers.size());
        this.nodeFrontiers.add(frontier);
    }

    public ITreeIndexFrame getLeafFrame() {
        return this.leafFrame;
    }

    public void setLeafFrame(ITreeIndexFrame leafFrame) {
        this.leafFrame = leafFrame;
    }

    public void write(ICachedPage cPage) throws HyracksDataException {
        this.compressedPageWriter.prepareWrite(cPage);
        this.pageWriter.write(cPage);
    }

    public void force() throws HyracksDataException {
        this.bufferCache.force(this.fileId, false);
    }
}

