/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.cloud.writer;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import org.apache.asterix.cloud.CloudResettableInputStream;
import org.apache.asterix.cloud.WriterSingleBufferProvider;
import org.apache.asterix.cloud.clients.ICloudBufferedWriter;
import org.apache.asterix.cloud.clients.ICloudClient;
import org.apache.asterix.cloud.clients.aws.s3.S3ClientConfig;
import org.apache.asterix.cloud.clients.aws.s3.S3CloudClient;
import org.apache.asterix.cloud.writer.AbstractCloudExternalFileWriter;
import org.apache.asterix.cloud.writer.S3ExternalFileWriter;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.external.util.aws.s3.S3Utils;
import org.apache.asterix.runtime.writer.ExternalFileWriterConfiguration;
import org.apache.asterix.runtime.writer.IExternalFileFilterWriterFactoryProvider;
import org.apache.asterix.runtime.writer.IExternalFilePrinter;
import org.apache.asterix.runtime.writer.IExternalFilePrinterFactory;
import org.apache.asterix.runtime.writer.IExternalFileWriter;
import org.apache.asterix.runtime.writer.IExternalFileWriterFactory;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.api.util.ExceptionUtils;
import org.apache.hyracks.data.std.primitive.LongPointable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.services.s3.model.NoSuchBucketException;

public final class S3ExternalFileWriterFactory
implements IExternalFileWriterFactory {
    private static final long serialVersionUID = 4551318140901866805L;
    private static final Logger LOGGER = LogManager.getLogger();
    static final char SEPARATOR = '/';
    public static final IExternalFileFilterWriterFactoryProvider PROVIDER = new IExternalFileFilterWriterFactoryProvider(){

        public IExternalFileWriterFactory create(ExternalFileWriterConfiguration configuration) {
            return new S3ExternalFileWriterFactory(configuration);
        }

        public char getSeparator() {
            return '/';
        }
    };
    private final Map<String, String> configuration;
    private final SourceLocation pathSourceLocation;
    private final String staticPath;
    private transient S3CloudClient cloudClient;

    private S3ExternalFileWriterFactory(ExternalFileWriterConfiguration externalConfig) {
        this.configuration = externalConfig.getConfiguration();
        this.pathSourceLocation = externalConfig.getPathSourceLocation();
        this.staticPath = externalConfig.getStaticPath();
        this.cloudClient = null;
    }

    public IExternalFileWriter createWriter(IHyracksTaskContext context, IExternalFilePrinterFactory printerFactory) throws HyracksDataException {
        this.buildClient();
        String bucket = this.configuration.get("container");
        IExternalFilePrinter printer = printerFactory.createPrinter();
        IWarningCollector warningCollector = context.getWarningCollector();
        return new S3ExternalFileWriter(printer, this.cloudClient, bucket, this.staticPath == null, warningCollector, this.pathSourceLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildClient() throws HyracksDataException {
        try {
            S3ExternalFileWriterFactory s3ExternalFileWriterFactory = this;
            synchronized (s3ExternalFileWriterFactory) {
                if (this.cloudClient == null) {
                    S3ClientConfig config = S3ClientConfig.of(this.configuration);
                    this.cloudClient = new S3CloudClient(config, S3Utils.buildAwsS3Client(this.configuration));
                }
            }
        }
        catch (CompilationException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public char getSeparator() {
        return '/';
    }

    public void validate() throws AlgebricksException {
        S3ClientConfig config = S3ClientConfig.of(this.configuration);
        S3CloudClient testClient = new S3CloudClient(config, S3Utils.buildAwsS3Client(this.configuration));
        String bucket = this.configuration.get("container");
        if (bucket == null || bucket.isEmpty()) {
            throw new CompilationException(ErrorCode.PARAMETERS_REQUIRED, new Serializable[]{"container"});
        }
        try {
            this.doValidate(testClient, bucket);
        }
        catch (IOException e) {
            if (e.getCause() instanceof NoSuchBucketException) {
                throw CompilationException.create((ErrorCode)ErrorCode.EXTERNAL_SOURCE_CONTAINER_NOT_FOUND, (Serializable[])new Serializable[]{bucket});
            }
            throw CompilationException.create((ErrorCode)ErrorCode.EXTERNAL_SOURCE_ERROR, (Serializable[])new Serializable[]{ExceptionUtils.getMessageOrToString((Throwable)e)});
        }
        catch (SdkException e) {
            throw CompilationException.create((ErrorCode)ErrorCode.EXTERNAL_SOURCE_ERROR, (Serializable[])new Serializable[]{e, ExceptionUtils.getMessageOrToString((Throwable)e)});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doValidate(ICloudClient testClient, String bucket) throws IOException, AlgebricksException {
        if (this.staticPath != null) {
            if (AbstractCloudExternalFileWriter.isExceedingMaxLength(this.staticPath, S3ExternalFileWriter.MAX_LENGTH_IN_BYTES)) {
                throw new CompilationException(ErrorCode.WRITE_PATH_LENGTH_EXCEEDS_MAX_LENGTH, this.pathSourceLocation, new Serializable[]{this.staticPath, Integer.valueOf(S3ExternalFileWriter.MAX_LENGTH_IN_BYTES), "S3"});
            }
            if (!testClient.isEmptyPrefix(bucket, this.staticPath)) {
                throw new CompilationException(ErrorCode.DIRECTORY_IS_NOT_EMPTY, this.pathSourceLocation, new Serializable[]{this.staticPath});
            }
        }
        Random random = new Random();
        String pathPrefix = "testFile";
        String path = pathPrefix + random.nextInt();
        while (testClient.exists(bucket, path)) {
            path = pathPrefix + random.nextInt();
        }
        long writeValue = random.nextLong();
        byte[] data = new byte[8];
        LongPointable.setLong((byte[])data, (int)0, (long)writeValue);
        ICloudBufferedWriter writer = testClient.createBufferedWriter(bucket, path);
        CloudResettableInputStream stream = null;
        boolean aborted = false;
        try {
            stream = new CloudResettableInputStream(writer, new WriterSingleBufferProvider());
            stream.write(data, 0, data.length);
        }
        catch (HyracksDataException e) {
            stream.abort();
            aborted = true;
        }
        finally {
            if (stream != null && !aborted) {
                stream.finish();
                stream.close();
            }
        }
        try {
            long readValue = LongPointable.getLong((byte[])testClient.readAllBytes(bucket, path), (int)0);
            if (writeValue != readValue) {
                LOGGER.warn("The writer can write but the written values wasn't successfully read back (wrote: {}, read:{})", (Object)writeValue, (Object)readValue);
            }
        }
        finally {
            testClient.deleteObjects(bucket, Collections.singleton(path));
        }
    }
}

