/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.geo.evaluators.functions;

import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.ogc.OGCConcreteGeometryCollection;
import com.esri.core.geometry.ogc.OGCGeometry;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.asterix.dataflow.data.nontagged.serde.AOrderedListSerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AGeometry;
import org.apache.asterix.om.base.IACollection;
import org.apache.asterix.om.base.IACursor;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.exceptions.InvalidDataFormatException;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class STPolygonizeDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    public static final IFunctionDescriptorFactory FACTORY = STPolygonizeDescriptor::new;
    private static final long serialVersionUID = 1L;

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.ST_POLYGONIZE;
    }

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(IEvaluatorContext ctx) throws HyracksDataException {
                return new STPolygonizeEvaluator(args, ctx);
            }
        };
    }

    private class STPolygonizeEvaluator
    implements IScalarEvaluator {
        private ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
        private DataOutput out = this.resultStorage.getDataOutput();
        private IPointable inputArg = new VoidPointable();
        private IScalarEvaluator eval;

        public STPolygonizeEvaluator(IScalarEvaluatorFactory[] args, IEvaluatorContext ctx) throws HyracksDataException {
            this.eval = args[0].createScalarEvaluator(ctx);
        }

        public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
            AOrderedListSerializerDeserializer serde;
            this.eval.evaluate(tuple, this.inputArg);
            byte[] bytes = this.inputArg.getByteArray();
            int offset = this.inputArg.getStartOffset();
            int len = this.inputArg.getLength();
            AOrderedListType type = new AOrderedListType((IAType)BuiltinType.AGEOMETRY, null);
            byte typeTag = this.inputArg.getByteArray()[this.inputArg.getStartOffset()];
            if (typeTag == ATypeTag.SERIALIZED_ORDEREDLIST_TYPE_TAG) {
                serde = new AOrderedListSerializerDeserializer(type);
            } else if (typeTag == ATypeTag.SERIALIZED_UNORDEREDLIST_TYPE_TAG) {
                serde = new AOrderedListSerializerDeserializer(type);
            } else {
                throw new TypeMismatchException(STPolygonizeDescriptor.this.sourceLoc, BuiltinFunctions.ST_POLYGONIZE, 0, typeTag, new byte[]{ATypeTag.SERIALIZED_ORDEREDLIST_TYPE_TAG, ATypeTag.SERIALIZED_UNORDEREDLIST_TYPE_TAG});
            }
            ByteArrayInputStream inStream = new ByteArrayInputStream(bytes, offset + 1, len - 1);
            DataInputStream dataIn = new DataInputStream(inStream);
            IACursor cursor = ((IACollection)serde.deserialize((DataInput)dataIn)).getCursor();
            ArrayList<OGCGeometry> list = new ArrayList<OGCGeometry>();
            while (cursor.next()) {
                IAObject object = cursor.get();
                list.add(((AGeometry)object).getGeometry());
            }
            OGCConcreteGeometryCollection geometryCollection = new OGCConcreteGeometryCollection(list, SpatialReference.create((int)4326));
            try {
                SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AGEOMETRY).serialize((Object)new AGeometry((OGCGeometry)geometryCollection), this.out);
            }
            catch (IOException e) {
                throw new InvalidDataFormatException(STPolygonizeDescriptor.this.sourceLoc, STPolygonizeDescriptor.this.getIdentifier(), (Throwable)e, ATypeTag.SERIALIZED_GEOMETRY_TYPE_TAG);
            }
            result.set((IValueReference)this.resultStorage);
        }
    }
}

