/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.pushdown;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.optimizer.rules.pushdown.descriptor.DefineDescriptor;
import org.apache.asterix.optimizer.rules.pushdown.descriptor.ScanDefineDescriptor;
import org.apache.asterix.optimizer.rules.pushdown.descriptor.UseDescriptor;
import org.apache.asterix.optimizer.rules.pushdown.visitor.FilterExpressionInlineVisitor;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractScanOperator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PushdownContext {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Set<LogicalOperatorTag> SCOPE_OPERATORS = PushdownContext.getScopeOperators();
    private final List<ScanDefineDescriptor> registeredScans = new ArrayList<ScanDefineDescriptor>();
    private final Map<ILogicalExpression, DefineDescriptor> definedVariable = new HashMap<ILogicalExpression, DefineDescriptor>();
    private final Map<LogicalVariable, DefineDescriptor> defineChain = new HashMap<LogicalVariable, DefineDescriptor>();
    private final Map<LogicalVariable, List<UseDescriptor>> useChain = new HashMap<LogicalVariable, List<UseDescriptor>>();
    private final List<ILogicalOperator> scopes = new ArrayList<ILogicalOperator>();
    private final FilterExpressionInlineVisitor inlineVisitor;
    private final Map<Dataset, List<ScanDefineDescriptor>> datasetToScans;
    private ILogicalOperator currentSubplan;

    public PushdownContext(IOptimizationContext context) {
        this.inlineVisitor = new FilterExpressionInlineVisitor(this, context);
        this.datasetToScans = new HashMap<Dataset, List<ScanDefineDescriptor>>();
    }

    public void enterScope(ILogicalOperator operator) {
        LogicalOperatorTag opTag = operator.getOperatorTag();
        if (SCOPE_OPERATORS.contains(opTag)) {
            this.scopes.add(operator);
        } else if (opTag == LogicalOperatorTag.AGGREGATE && this.currentSubplan == null) {
            this.scopes.add(operator);
        }
    }

    public ILogicalOperator enterSubplan(ILogicalOperator subplanOp) {
        ILogicalOperator previous = this.currentSubplan;
        this.currentSubplan = subplanOp;
        return previous;
    }

    public void exitSubplan(ILogicalOperator previousSubplan) {
        this.currentSubplan = previousSubplan;
    }

    public void registerScan(Dataset dataset, List<LogicalVariable> pkList, LogicalVariable recordVariable, LogicalVariable metaVariable, AbstractScanOperator scanOperator) {
        ScanDefineDescriptor scanDefDesc = new ScanDefineDescriptor(this.scopes.size(), dataset, pkList, recordVariable, metaVariable, (ILogicalOperator)scanOperator);
        this.defineChain.put(recordVariable, scanDefDesc);
        this.useChain.put(recordVariable, new ArrayList());
        if (metaVariable != null) {
            this.defineChain.put(metaVariable, scanDefDesc);
            this.useChain.put(metaVariable, new ArrayList());
        }
        for (LogicalVariable pkVar : pkList) {
            this.defineChain.put(pkVar, scanDefDesc);
            this.useChain.put(pkVar, new ArrayList());
        }
        this.registeredScans.add(scanDefDesc);
        List datasetScans = this.datasetToScans.computeIfAbsent(dataset, k -> new ArrayList());
        datasetScans.add(scanDefDesc);
    }

    public Map<Dataset, List<ScanDefineDescriptor>> getDatasetToScanDefinitionDescriptors() {
        return this.datasetToScans;
    }

    public void define(LogicalVariable variable, ILogicalOperator operator, ILogicalExpression expression, int expressionIndex) {
        if (this.defineChain.containsKey(variable)) {
            LOGGER.warn("Variable {}  declared twice", (Object)variable);
            return;
        }
        if (this.definedVariable.containsKey(expression)) {
            DefineDescriptor defineDescriptor = this.definedVariable.get(expression);
            LOGGER.debug("Expression {} is redundant. It was seen at {}", (Object)expression, (Object)defineDescriptor.toString());
        }
        int scope = this.scopes.size();
        DefineDescriptor defineDescriptor = new DefineDescriptor(scope, this.currentSubplan, variable, operator, expression, expressionIndex);
        this.definedVariable.put(expression, defineDescriptor);
        this.defineChain.put(variable, defineDescriptor);
        this.useChain.put(variable, new ArrayList());
    }

    public void use(ILogicalOperator operator, ILogicalExpression expression, int expressionIndex, LogicalVariable producedVariable) {
        int scope = this.scopes.size();
        UseDescriptor useDescriptor = new UseDescriptor(scope, this.currentSubplan, operator, expression, expressionIndex, producedVariable);
        Set<LogicalVariable> usedVariables = useDescriptor.getUsedVariables();
        expression.getUsedVariables(usedVariables);
        for (LogicalVariable variable : usedVariables) {
            DefineDescriptor defineDescriptor = this.defineChain.get(variable);
            if (defineDescriptor == null) {
                LOGGER.warn("Variable {} is not defined", (Object)variable);
                return;
            }
            List<UseDescriptor> uses = this.useChain.get(variable);
            uses.add(useDescriptor);
        }
    }

    public DefineDescriptor getDefineDescriptor(LogicalVariable variable) {
        return this.defineChain.get(variable);
    }

    public DefineDescriptor getDefineDescriptor(UseDescriptor useDescriptor) {
        LogicalVariable producedVariable = useDescriptor.getProducedVariable();
        if (producedVariable == null) {
            return null;
        }
        return this.getDefineDescriptor(producedVariable);
    }

    public List<UseDescriptor> getUseDescriptors(DefineDescriptor defineDescriptor) {
        return this.useChain.get(defineDescriptor.getVariable());
    }

    public List<ScanDefineDescriptor> getRegisteredScans() {
        return this.registeredScans;
    }

    public FilterExpressionInlineVisitor getInlineVisitor() {
        return this.inlineVisitor;
    }

    private static Set<LogicalOperatorTag> getScopeOperators() {
        return EnumSet.of(LogicalOperatorTag.INNERJOIN, new LogicalOperatorTag[]{LogicalOperatorTag.LEFTOUTERJOIN, LogicalOperatorTag.GROUP, LogicalOperatorTag.WINDOW, LogicalOperatorTag.RUNNINGAGGREGATE, LogicalOperatorTag.UNIONALL, LogicalOperatorTag.INTERSECT});
    }
}

