/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.metadata.schema.visitor;

import java.io.IOException;
import java.util.Map;
import org.apache.asterix.column.metadata.FieldNamesDictionary;
import org.apache.asterix.column.metadata.schema.AbstractSchemaNode;
import org.apache.asterix.column.metadata.schema.ObjectSchemaNode;
import org.apache.asterix.column.metadata.schema.UnionSchemaNode;
import org.apache.asterix.column.metadata.schema.collection.AbstractCollectionSchemaNode;
import org.apache.asterix.column.metadata.schema.primitive.MissingFieldSchemaNode;
import org.apache.asterix.column.metadata.schema.primitive.PrimitiveSchemaNode;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.IATypeVisitor;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.runtime.projection.FunctionCallInformation;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.api.exceptions.Warning;

public class SchemaClipperVisitor
implements IATypeVisitor<AbstractSchemaNode, AbstractSchemaNode> {
    private final FieldNamesDictionary fieldNamesDictionary;
    private final IWarningCollector warningCollector;
    private final Map<String, FunctionCallInformation> functionCallInfoMap;
    private boolean ignoreFlatType;

    public SchemaClipperVisitor(FieldNamesDictionary fieldNamesDictionary, Map<String, FunctionCallInformation> functionCallInfoMap, IWarningCollector warningCollector) {
        this.fieldNamesDictionary = fieldNamesDictionary;
        this.functionCallInfoMap = functionCallInfoMap;
        this.warningCollector = warningCollector;
        this.ignoreFlatType = false;
    }

    public void setIgnoreFlatType(boolean ignoreFlatType) {
        this.ignoreFlatType = ignoreFlatType;
    }

    public AbstractSchemaNode visit(ARecordType recordType, AbstractSchemaNode arg) {
        if (this.isNotCompatible((IAType)recordType, arg)) {
            return MissingFieldSchemaNode.INSTANCE;
        }
        String[] fieldNames = recordType.getFieldNames();
        IAType[] fieldTypes = recordType.getFieldTypes();
        ObjectSchemaNode objectNode = this.getActualNode(arg, ATypeTag.OBJECT, ObjectSchemaNode.class);
        ObjectSchemaNode clippedObjectNode = new ObjectSchemaNode();
        try {
            for (int i = 0; i < fieldNames.length; ++i) {
                int fieldNameIndex = this.fieldNamesDictionary.getFieldNameIndex(fieldNames[i]);
                if (fieldNameIndex == -1) continue;
                AbstractSchemaNode child = objectNode.getChild(fieldNameIndex);
                clippedObjectNode.addChild(fieldNameIndex, (AbstractSchemaNode)fieldTypes[i].accept((IATypeVisitor)this, (Object)child));
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return clippedObjectNode;
    }

    public AbstractSchemaNode visit(AbstractCollectionType collectionType, AbstractSchemaNode arg) {
        if (!arg.isCollection() && this.isNotCompatible((IAType)collectionType, arg)) {
            return MissingFieldSchemaNode.INSTANCE;
        }
        ATypeTag typeTag = arg.isCollection() ? arg.getTypeTag() : ATypeTag.ARRAY;
        AbstractCollectionSchemaNode collectionNode = this.getActualNode(arg, typeTag, AbstractCollectionSchemaNode.class);
        AbstractSchemaNode newItemNode = (AbstractSchemaNode)collectionType.getItemType().accept((IATypeVisitor)this, (Object)collectionNode.getItemNode());
        AbstractCollectionSchemaNode clippedCollectionNode = AbstractCollectionSchemaNode.create(collectionType.getTypeTag());
        clippedCollectionNode.setItemNode(newItemNode);
        return clippedCollectionNode;
    }

    public AbstractSchemaNode visit(AUnionType unionType, AbstractSchemaNode arg) {
        return arg;
    }

    public AbstractSchemaNode visitFlat(IAType flatType, AbstractSchemaNode arg) {
        if (this.ignoreFlatType || flatType.getTypeTag() == ATypeTag.ANY) {
            return arg;
        }
        if (this.isNotCompatible(flatType, arg)) {
            return this.getNonCompatibleNumericNodeIfAny(flatType, arg);
        }
        return this.getActualNode(arg, flatType.getTypeTag(), PrimitiveSchemaNode.class);
    }

    private AbstractSchemaNode getNonCompatibleNumericNodeIfAny(IAType flatType, AbstractSchemaNode arg) {
        if (SchemaClipperVisitor.isNumeric(flatType.getTypeTag()) && SchemaClipperVisitor.isNumeric(arg.getTypeTag())) {
            return arg;
        }
        if (arg.getTypeTag() == ATypeTag.UNION) {
            UnionSchemaNode unionNode = (UnionSchemaNode)arg;
            return unionNode.getNumericChildOrMissing(flatType.getTypeTag());
        }
        return MissingFieldSchemaNode.INSTANCE;
    }

    private <T extends AbstractSchemaNode> T getActualNode(AbstractSchemaNode node, ATypeTag typeTag, Class<T> clazz) {
        if (node.getTypeTag() == typeTag) {
            return (T)((AbstractSchemaNode)clazz.cast(node));
        }
        UnionSchemaNode unionNode = (UnionSchemaNode)node;
        return (T)((AbstractSchemaNode)clazz.cast(unionNode.getChild(typeTag)));
    }

    private boolean isNotCompatible(IAType requestedType, AbstractSchemaNode schemaNode) {
        if (schemaNode.getTypeTag() == ATypeTag.MISSING) {
            return true;
        }
        ATypeTag requestedTypeTag = requestedType.getTypeTag();
        if (requestedTypeTag != schemaNode.getTypeTag()) {
            if (schemaNode.getTypeTag() != ATypeTag.UNION) {
                this.warn(requestedType, schemaNode);
                return true;
            }
            UnionSchemaNode unionNode = (UnionSchemaNode)schemaNode;
            return this.notInUnion(requestedType, unionNode) || SchemaClipperVisitor.isNumeric(requestedTypeTag) && this.unionContainsMultipleNumeric(schemaNode);
        }
        return this.unionContainsMultipleNumeric(schemaNode);
    }

    private boolean notInUnion(IAType requestedType, UnionSchemaNode unionNode) {
        for (AbstractSchemaNode unionChildNode : unionNode.getChildren().values()) {
            this.warn(requestedType, unionChildNode);
        }
        return !unionNode.getChildren().containsKey(requestedType.getTypeTag());
    }

    private void warn(IAType requestedType, AbstractSchemaNode schemaNode) {
        Warning warning;
        if (ATypeHierarchy.isCompatible((ATypeTag)requestedType.getTypeTag(), (ATypeTag)schemaNode.getTypeTag())) {
            return;
        }
        if (this.warningCollector.shouldWarn() && this.functionCallInfoMap.containsKey(requestedType.getTypeName()) && (warning = this.functionCallInfoMap.get(requestedType.getTypeName()).createWarning(requestedType.getTypeTag(), schemaNode.getTypeTag())) != null) {
            this.warningCollector.warn(warning);
        }
    }

    private boolean unionContainsMultipleNumeric(AbstractSchemaNode schemaNode) {
        if (schemaNode.getTypeTag() == ATypeTag.UNION) {
            UnionSchemaNode unionNode = (UnionSchemaNode)schemaNode;
            return unionNode.getNumberOfNumericChildren() > 1;
        }
        return false;
    }

    private static boolean isNumeric(ATypeTag typeTag) {
        return ATypeHierarchy.getTypeDomain((ATypeTag)typeTag) == ATypeHierarchy.Domain.NUMERIC;
    }
}

