/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.nc;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.algebra.base.ILangExtension;
import org.apache.asterix.common.api.ExtensionId;
import org.apache.asterix.common.api.IExtension;
import org.apache.asterix.common.api.INamespaceResolver;
import org.apache.asterix.common.config.AsterixExtension;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.compiler.provider.ILangCompilationProvider;
import org.apache.asterix.compiler.provider.SqlppCompilationProvider;
import org.apache.asterix.metadata.api.IMetadataExtension;
import org.apache.asterix.metadata.api.INCExtensionManager;
import org.apache.asterix.metadata.bootstrap.MetadataIndexesProvider;
import org.apache.asterix.metadata.entitytupletranslators.MetadataTupleTranslatorProvider;
import org.apache.asterix.utils.ExtensionUtil;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.api.application.INCServiceContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class NCExtensionManager
implements INCExtensionManager {
    private final ILangCompilationProvider sqlppCompilationProvider;
    private final MetadataTupleTranslatorProvider tupleTranslatorProvider;
    private final MetadataIndexesProvider metadataIndexesProvider;
    private final List<IMetadataExtension> mdExtensions;

    public NCExtensionManager(List<AsterixExtension> list, boolean usingDatabase, INamespaceResolver namespaceResolver) throws InstantiationException, IllegalAccessException, ClassNotFoundException, HyracksDataException {
        Pair<ExtensionId, ILangCompilationProvider> sqlppcp = null;
        IMetadataExtension tupleTranslatorProviderExtension = null;
        this.mdExtensions = new ArrayList<IMetadataExtension>();
        MetadataIndexesProvider mdIndexesProvider = new MetadataIndexesProvider(usingDatabase);
        if (list != null) {
            for (AsterixExtension extensionConf : list) {
                IExtension extension = (IExtension)Class.forName(extensionConf.getClassName()).newInstance();
                extension.configure(extensionConf.getArgs());
                switch (extension.getExtensionKind()) {
                    case LANG: {
                        ILangExtension le = (ILangExtension)extension;
                        sqlppcp = ExtensionUtil.extendLangCompilationProvider(ILangExtension.Language.SQLPP, sqlppcp, le, namespaceResolver);
                        break;
                    }
                    case METADATA: {
                        IMetadataExtension mde = (IMetadataExtension)extension;
                        this.mdExtensions.add(mde);
                        tupleTranslatorProviderExtension = ExtensionUtil.extendTupleTranslatorProvider(tupleTranslatorProviderExtension, mde, mdIndexesProvider);
                        break;
                    }
                }
            }
        }
        Object object = this.sqlppCompilationProvider = sqlppcp == null ? new SqlppCompilationProvider(namespaceResolver) : (ILangCompilationProvider)sqlppcp.second;
        if (tupleTranslatorProviderExtension == null) {
            this.metadataIndexesProvider = mdIndexesProvider;
            this.tupleTranslatorProvider = new MetadataTupleTranslatorProvider(this.metadataIndexesProvider);
        } else {
            this.metadataIndexesProvider = tupleTranslatorProviderExtension.getMetadataIndexesProvider(usingDatabase);
            this.tupleTranslatorProvider = tupleTranslatorProviderExtension.getMetadataTupleTranslatorProvider(this.metadataIndexesProvider);
        }
    }

    public ILangCompilationProvider getCompilationProvider(ILangExtension.Language lang) {
        switch (lang) {
            case SQLPP: {
                return this.sqlppCompilationProvider;
            }
        }
        throw new IllegalArgumentException(String.valueOf(lang));
    }

    public List<IMetadataExtension> getMetadataExtensions() {
        return this.mdExtensions;
    }

    public MetadataTupleTranslatorProvider getMetadataTupleTranslatorProvider() {
        return this.tupleTranslatorProvider;
    }

    public MetadataIndexesProvider getMetadataIndexesProvider() {
        return this.metadataIndexesProvider;
    }

    public void initializeMetadata(INCServiceContext ncServiceCtx, MetadataIndexesProvider mdIndexesProvider) throws HyracksDataException {
        if (this.mdExtensions != null) {
            for (IMetadataExtension mdExtension : this.mdExtensions) {
                try {
                    mdExtension.initializeMetadata(ncServiceCtx, mdIndexesProvider);
                }
                catch (RemoteException | ACIDException e) {
                    throw HyracksDataException.create((Throwable)e);
                }
            }
        }
    }
}

