/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.metadata;

import java.util.List;
import org.apache.asterix.common.api.INamespaceResolver;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.metadata.MetadataUtil;
import org.apache.asterix.common.metadata.Namespace;

public class NamespaceResolver
implements INamespaceResolver {
    private final boolean usingDatabase;

    public NamespaceResolver(boolean usingDatabase) {
        this.usingDatabase = usingDatabase;
    }

    @Override
    public Namespace resolve(List<String> multiIdentifier) throws AsterixException {
        return this.resolve(multiIdentifier, 0, multiIdentifier.size());
    }

    @Override
    public Namespace resolve(List<String> multiIdentifier, int fromIndex, int toIndex) throws AsterixException {
        if (multiIdentifier == null) {
            return null;
        }
        if (this.usingDatabase) {
            int partsNum = toIndex - fromIndex;
            if (partsNum > 1) {
                String databaseName = multiIdentifier.get(fromIndex);
                return NamespaceResolver.ofDatabase(databaseName, multiIdentifier, fromIndex + 1, toIndex);
            }
            return NamespaceResolver.ofDataverse(multiIdentifier, fromIndex, toIndex);
        }
        return NamespaceResolver.ofDataverse(multiIdentifier, fromIndex, toIndex);
    }

    @Override
    public Namespace resolve(String namespace) throws AsterixException {
        DataverseName dataverseName = DataverseName.createFromCanonicalForm(namespace);
        if (this.usingDatabase) {
            List<String> parts = dataverseName.getParts();
            if (parts.size() > 1) {
                String databaseName = parts.get(0);
                return NamespaceResolver.ofDatabase(databaseName, parts, 1, parts.size());
            }
            return new Namespace(MetadataUtil.databaseFor(dataverseName), dataverseName);
        }
        return new Namespace(MetadataUtil.databaseFor(dataverseName), dataverseName);
    }

    @Override
    public boolean isUsingDatabase() {
        return this.usingDatabase;
    }

    private static Namespace ofDatabase(String databaseName, List<String> multiIdentifier, int fromIndex, int toIndex) throws AsterixException {
        DataverseName dataverseName = DataverseName.create(multiIdentifier, fromIndex, toIndex);
        return new Namespace(databaseName, dataverseName);
    }

    private static Namespace ofDataverse(List<String> multiIdentifier, int fromIndex, int toIndex) throws AsterixException {
        DataverseName dataverseName = DataverseName.create(multiIdentifier, fromIndex, toIndex);
        return new Namespace(MetadataUtil.databaseFor(dataverseName), dataverseName);
    }
}

