/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.azure.datalake;

import com.azure.storage.file.datalake.DataLakeServiceClient;
import com.azure.storage.file.datalake.models.PathItem;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import org.apache.asterix.common.api.IApplicationContext;
import org.apache.asterix.common.external.IExternalFilterEvaluatorFactory;
import org.apache.asterix.external.api.AsterixInputStream;
import org.apache.asterix.external.api.IExternalDataRuntimeContext;
import org.apache.asterix.external.input.filter.embedder.IExternalFilterValueEmbedder;
import org.apache.asterix.external.input.record.reader.abstracts.AbstractExternalInputStreamFactory;
import org.apache.asterix.external.input.record.reader.azure.datalake.AzureDataLakeInputStream;
import org.apache.asterix.external.util.ExternalDataUtils;
import org.apache.asterix.external.util.azure.blob_storage.AzureUtils;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.application.IServiceContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IWarningCollector;

public class AzureDataLakeInputStreamFactory
extends AbstractExternalInputStreamFactory {
    private static final long serialVersionUID = 1L;

    @Override
    public AsterixInputStream createInputStream(IExternalDataRuntimeContext context) throws HyracksDataException {
        IApplicationContext appCtx = (IApplicationContext)context.getTaskContext().getJobletContext().getServiceContext().getApplicationContext();
        IExternalFilterValueEmbedder valueEmbedder = context.getValueEmbedder();
        int partition = context.getPartition();
        return new AzureDataLakeInputStream(appCtx, this.configuration, ((AbstractExternalInputStreamFactory.PartitionWorkLoadBasedOnSize)this.partitionWorkLoadsBasedOnSize.get(partition)).getFilePaths(), valueEmbedder);
    }

    @Override
    public void configure(IServiceContext ctx, Map<String, String> configuration, IWarningCollector warningCollector, IExternalFilterEvaluatorFactory filterEvaluatorFactory) throws AlgebricksException, HyracksDataException {
        super.configure(ctx, configuration, warningCollector, filterEvaluatorFactory);
        IApplicationContext appCtx = (IApplicationContext)ctx.getApplicationContext();
        AbstractExternalInputStreamFactory.IncludeExcludeMatcher includeExcludeMatcher = ExternalDataUtils.getIncludeExcludeMatchers(configuration);
        DataLakeServiceClient client = AzureUtils.buildAzureDatalakeClient(appCtx, configuration);
        List<PathItem> filesOnly = AzureUtils.listDatalakePathItems(client, configuration, includeExcludeMatcher, warningCollector);
        this.distributeWorkLoad(filesOnly, this.getPartitionsCount());
    }

    private void distributeWorkLoad(List<PathItem> items, int partitionsCount) {
        PriorityQueue<AbstractExternalInputStreamFactory.PartitionWorkLoadBasedOnSize> workloadQueue = new PriorityQueue<AbstractExternalInputStreamFactory.PartitionWorkLoadBasedOnSize>(partitionsCount, Comparator.comparingLong(AbstractExternalInputStreamFactory.PartitionWorkLoadBasedOnSize::getTotalSize));
        for (int i = 0; i < partitionsCount; ++i) {
            workloadQueue.add(new AbstractExternalInputStreamFactory.PartitionWorkLoadBasedOnSize());
        }
        for (PathItem object : items) {
            AbstractExternalInputStreamFactory.PartitionWorkLoadBasedOnSize workload = workloadQueue.poll();
            workload.addFilePath(object.getName(), object.getContentLength());
            workloadQueue.add(workload);
        }
        this.partitionWorkLoadsBasedOnSize.addAll(workloadQueue);
    }
}

