/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.util;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.external.util.ExternalDataConstants;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class WriterValidationUtil {
    private WriterValidationUtil() {
    }

    public static void validateWriterConfiguration(String adapter, Set<String> supportedAdapters, Map<String, String> configuration, SourceLocation sourceLocation) throws CompilationException {
        WriterValidationUtil.validateAdapter(adapter, supportedAdapters, sourceLocation);
        WriterValidationUtil.validateFormat(configuration, sourceLocation);
        WriterValidationUtil.validateCompression(configuration, sourceLocation);
        WriterValidationUtil.validateMaxResult(configuration, sourceLocation);
    }

    private static void validateAdapter(String adapter, Set<String> supportedAdapters, SourceLocation sourceLocation) throws CompilationException {
        WriterValidationUtil.checkSupported("type", adapter, supportedAdapters, ErrorCode.UNSUPPORTED_WRITING_ADAPTER, sourceLocation, false);
    }

    private static void validateFormat(Map<String, String> configuration, SourceLocation sourceLocation) throws CompilationException {
        String format = configuration.get("format");
        WriterValidationUtil.checkSupported("format", format, ExternalDataConstants.WRITER_SUPPORTED_FORMATS, ErrorCode.UNSUPPORTED_WRITING_FORMAT, sourceLocation, false);
    }

    private static void validateCompression(Map<String, String> configuration, SourceLocation sourceLocation) throws CompilationException {
        String compression = configuration.get("compression");
        WriterValidationUtil.checkSupported("compression", compression, ExternalDataConstants.WRITER_SUPPORTED_COMPRESSION, ErrorCode.UNKNOWN_COMPRESSION_SCHEME, sourceLocation, true);
    }

    private static void validateMaxResult(Map<String, String> configuration, SourceLocation sourceLocation) throws CompilationException {
        String maxResult = configuration.get("max-objects-per-file");
        if (maxResult == null) {
            return;
        }
        try {
            Integer.parseInt(maxResult);
        }
        catch (NumberFormatException e) {
            throw CompilationException.create((ErrorCode)ErrorCode.INTEGER_VALUE_EXPECTED, (SourceLocation)sourceLocation, (Serializable[])new Serializable[]{maxResult});
        }
    }

    private static void checkSupported(String paramKey, String value, Set<String> supportedSet, ErrorCode errorCode, SourceLocation sourceLocation, boolean optional) throws CompilationException {
        if (optional && value == null) {
            return;
        }
        if (value == null) {
            throw new CompilationException(ErrorCode.PARAMETERS_REQUIRED, sourceLocation, new Serializable[]{paramKey});
        }
        String normalizedValue = value.toLowerCase();
        if (!supportedSet.contains(normalizedValue)) {
            List sorted = supportedSet.stream().sorted().collect(Collectors.toList());
            throw CompilationException.create((ErrorCode)errorCode, (SourceLocation)sourceLocation, (Serializable[])new Serializable[]{value, sorted.toString()});
        }
    }
}

