/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.rewriter.rules;

import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.IPhysicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.PhysicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.HashPartitionExchangePOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.HashPartitionMergeExchangePOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.SortMergeExchangePOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.OrderColumn;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class RemoveUnnecessarySortMergeExchange
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op1 = (AbstractLogicalOperator)opRef.getValue();
        if (op1.getPhysicalOperator() == null || op1.getPhysicalOperator().getOperatorTag() != PhysicalOperatorTag.HASH_PARTITION_EXCHANGE && op1.getPhysicalOperator().getOperatorTag() != PhysicalOperatorTag.HASH_PARTITION_MERGE_EXCHANGE) {
            return false;
        }
        Mutable currentOpRef = (Mutable)op1.getInputs().get(0);
        AbstractLogicalOperator currentOp = (AbstractLogicalOperator)currentOpRef.getValue();
        while (currentOp != null) {
            IPhysicalOperator physicalOp = currentOp.getPhysicalOperator();
            if (physicalOp == null) {
                return false;
            }
            if (physicalOp.getOperatorTag() == PhysicalOperatorTag.SORT_MERGE_EXCHANGE) break;
            if (!currentOp.isMap() || currentOp.getOperatorTag() == LogicalOperatorTag.UNNEST) {
                return false;
            }
            if (currentOp.getInputs().size() == 1) {
                currentOpRef = (Mutable)currentOp.getInputs().get(0);
                currentOp = (AbstractLogicalOperator)currentOpRef.getValue();
                continue;
            }
            currentOp = null;
        }
        if (currentOp == null) {
            return false;
        }
        if (op1.getPhysicalOperator().getOperatorTag() == PhysicalOperatorTag.HASH_PARTITION_MERGE_EXCHANGE) {
            currentOpRef.setValue((Object)((ILogicalOperator)((Mutable)currentOp.getInputs().get(0)).getValue()));
            op1.computeDeliveredPhysicalProperties(context);
            return true;
        }
        SortMergeExchangePOperator sme = (SortMergeExchangePOperator)currentOp.getPhysicalOperator();
        HashPartitionExchangePOperator hpe = (HashPartitionExchangePOperator)op1.getPhysicalOperator();
        HashSet liveVars = new HashSet();
        VariableUtilities.getLiveVariables((ILogicalOperator)op1, liveVars);
        boolean usingHashMergeExchange = true;
        for (OrderColumn oc : sme.getSortColumns()) {
            if (liveVars.contains(oc.getColumn())) continue;
            usingHashMergeExchange = false;
            break;
        }
        if (usingHashMergeExchange) {
            ArrayList<OrderColumn> ocList = new ArrayList<OrderColumn>();
            for (OrderColumn oc : sme.getSortColumns()) {
                ocList.add(oc);
            }
            HashPartitionMergeExchangePOperator hpme = new HashPartitionMergeExchangePOperator(ocList, hpe.getHashFields(), hpe.getDomain(), hpe.getPartitionsMap());
            op1.setPhysicalOperator((IPhysicalOperator)hpme);
        }
        currentOpRef.setValue((Object)((ILogicalOperator)((Mutable)currentOp.getInputs().get(0)).getValue()));
        op1.computeDeliveredPhysicalProperties(context);
        return true;
    }
}

