/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.projection;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.IATypeVisitor;
import org.apache.asterix.om.types.visitor.SimpleStringBuilderForIATypeVisitor;
import org.apache.asterix.om.utils.ProjectionFiltrationTypeUtil;
import org.apache.asterix.runtime.projection.FunctionCallInformation;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.metadata.IProjectionFiltrationInfo;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.EquivalentVariableExpressionComparatorVisitor;
import org.apache.hyracks.algebricks.core.algebra.prettyprint.AlgebricksStringBuilderWriter;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionVisitor;

public class ExternalDatasetProjectionFiltrationInfo
implements IProjectionFiltrationInfo {
    protected final ARecordType projectedType;
    protected final ILogicalExpression filterExpression;
    protected final Map<String, FunctionCallInformation> functionCallInfoMap;
    private final boolean embedFilterValues;
    protected final Map<ILogicalExpression, ARecordType> filterPaths;

    public ExternalDatasetProjectionFiltrationInfo(ARecordType projectedType, Map<String, FunctionCallInformation> sourceInformationMap, Map<ILogicalExpression, ARecordType> filterPaths, ILogicalExpression filterExpression, boolean embedFilterValues) {
        this.projectedType = projectedType;
        this.functionCallInfoMap = sourceInformationMap;
        this.filterExpression = filterExpression;
        this.filterPaths = filterPaths;
        this.embedFilterValues = embedFilterValues;
    }

    private ExternalDatasetProjectionFiltrationInfo(ExternalDatasetProjectionFiltrationInfo other) {
        this.projectedType = other.projectedType == ProjectionFiltrationTypeUtil.ALL_FIELDS_TYPE ? ProjectionFiltrationTypeUtil.ALL_FIELDS_TYPE : (other.projectedType == ProjectionFiltrationTypeUtil.EMPTY_TYPE ? ProjectionFiltrationTypeUtil.EMPTY_TYPE : other.projectedType.deepCopy(other.projectedType));
        this.functionCallInfoMap = new HashMap<String, FunctionCallInformation>(other.functionCallInfoMap);
        this.filterExpression = ExternalDatasetProjectionFiltrationInfo.cloneExpression(other.filterExpression);
        this.filterPaths = ExternalDatasetProjectionFiltrationInfo.clonePaths(other.filterPaths);
        this.embedFilterValues = other.embedFilterValues;
    }

    public void substituteFilterVariable(LogicalVariable oldVar, LogicalVariable newVar) {
        if (this.filterExpression != null) {
            this.filterExpression.substituteVar(oldVar, newVar);
        }
        HashMap<ILogicalExpression, ARecordType> newPaths = new HashMap<ILogicalExpression, ARecordType>(this.filterPaths);
        this.filterPaths.clear();
        for (Map.Entry path : newPaths.entrySet()) {
            ILogicalExpression expr = (ILogicalExpression)path.getKey();
            ARecordType type = (ARecordType)path.getValue();
            expr.substituteVar(oldVar, newVar);
            this.filterPaths.put(expr, type);
        }
    }

    public ExternalDatasetProjectionFiltrationInfo createCopy() {
        return new ExternalDatasetProjectionFiltrationInfo(this);
    }

    public ARecordType getProjectedType() {
        return this.projectedType;
    }

    public Map<String, FunctionCallInformation> getFunctionCallInfoMap() {
        return this.functionCallInfoMap;
    }

    public ILogicalExpression getFilterExpression() {
        return this.filterExpression;
    }

    public Map<ILogicalExpression, ARecordType> getFilterPaths() {
        return this.filterPaths;
    }

    public boolean isEmbedFilterValues() {
        return this.embedFilterValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalDatasetProjectionFiltrationInfo otherInfo = (ExternalDatasetProjectionFiltrationInfo)o;
        return this.projectedType.deepEqual((IAObject)otherInfo.projectedType) && ExternalDatasetProjectionFiltrationInfo.filterExpressionEquals(this.filterExpression, otherInfo.filterExpression);
    }

    public void print(AlgebricksStringBuilderWriter writer) {
        if (this.projectedType != ProjectionFiltrationTypeUtil.ALL_FIELDS_TYPE) {
            writer.append((CharSequence)" project (");
            if (this.projectedType == ProjectionFiltrationTypeUtil.EMPTY_TYPE) {
                writer.append((CharSequence)this.projectedType.getTypeName());
            } else {
                writer.append((CharSequence)ExternalDatasetProjectionFiltrationInfo.getOnelinerSchema(this.projectedType, new StringBuilder()));
            }
            writer.append(')');
        }
        if (this.filterExpression != null) {
            writer.append((CharSequence)" prefix-filter on: ");
            writer.append((CharSequence)this.filterExpression.toString());
        }
        if (this.embedFilterValues) {
            writer.append((CharSequence)" embed-filter-value: ");
            writer.append((CharSequence)String.valueOf(true));
        }
    }

    public void print(JsonGenerator generator) throws IOException {
        StringBuilder builder = new StringBuilder();
        if (this.projectedType != ProjectionFiltrationTypeUtil.ALL_FIELDS_TYPE) {
            if (this.projectedType == ProjectionFiltrationTypeUtil.EMPTY_TYPE) {
                generator.writeStringField("project", this.projectedType.getTypeName());
            } else {
                generator.writeStringField("project", ExternalDatasetProjectionFiltrationInfo.getOnelinerSchema(this.projectedType, builder));
            }
        }
        if (this.filterExpression != null) {
            generator.writeStringField("prefix-filter-on", this.filterExpression.toString());
        }
        if (this.embedFilterValues) {
            generator.writeBooleanField("embed-filter-value", true);
        }
    }

    protected static ILogicalExpression cloneExpression(ILogicalExpression expression) {
        if (expression == null) {
            return null;
        }
        return expression.cloneExpression();
    }

    protected static Map<ILogicalExpression, ARecordType> clonePaths(Map<ILogicalExpression, ARecordType> filterPaths) {
        HashMap<ILogicalExpression, ARecordType> newFilterPaths = new HashMap<ILogicalExpression, ARecordType>(filterPaths.size());
        for (Map.Entry<ILogicalExpression, ARecordType> path : filterPaths.entrySet()) {
            newFilterPaths.put(path.getKey().cloneExpression(), path.getValue());
        }
        return newFilterPaths;
    }

    protected static String getOnelinerSchema(ARecordType type, StringBuilder builder) {
        SimpleStringBuilderForIATypeVisitor visitor = new SimpleStringBuilderForIATypeVisitor();
        type.accept((IATypeVisitor)visitor, (Object)builder);
        String onelinerSchema = builder.toString();
        builder.setLength(0);
        return onelinerSchema;
    }

    protected static boolean filterExpressionEquals(ILogicalExpression expr1, ILogicalExpression expr2) {
        if (expr1 == expr2) {
            return true;
        }
        if (expr1 == null || expr2 == null) {
            return false;
        }
        try {
            return expr1.accept((ILogicalExpressionVisitor)EquivalentVariableExpressionComparatorVisitor.INSTANCE, (Object)expr2) == Boolean.TRUE;
        }
        catch (AlgebricksException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeTypeField(ARecordType expectedRecordType, DataOutput output) throws IOException {
        byte[] recordTypeBytes = SerializationUtils.serialize((Serializable)expectedRecordType);
        output.writeInt(recordTypeBytes.length);
        output.write(recordTypeBytes);
    }

    public static ARecordType createTypeField(DataInput input) throws IOException {
        int length = input.readInt();
        byte[] recordTypeBytes = new byte[length];
        input.readFully(recordTypeBytes, 0, length);
        return (ARecordType)SerializationUtils.deserialize((byte[])recordTypeBytes);
    }

    public static void writeFunctionCallInformationMapField(Map<String, FunctionCallInformation> functionCallInfoMap, DataOutput output) throws IOException {
        output.writeInt(functionCallInfoMap.size());
        for (Map.Entry<String, FunctionCallInformation> info : functionCallInfoMap.entrySet()) {
            output.writeUTF(info.getKey());
            info.getValue().writeFields(output);
        }
    }

    public static Map<String, FunctionCallInformation> createFunctionCallInformationMap(DataInput input) throws IOException {
        int size = input.readInt();
        HashMap<String, FunctionCallInformation> functionCallInfoMap = new HashMap<String, FunctionCallInformation>();
        for (int i = 0; i < size; ++i) {
            String key = input.readUTF();
            FunctionCallInformation functionCallInfo = FunctionCallInformation.create(input);
            functionCallInfoMap.put(key, functionCallInfo);
        }
        return functionCallInfoMap;
    }
}

