/*
 * Decompiled with CFR 0.152.
 */
package tech.allegro.schema.json2avro.converter.types;

import java.util.Deque;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilderBase;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecordBuilder;
import tech.allegro.schema.json2avro.converter.JsonToAvroReader;
import tech.allegro.schema.json2avro.converter.PathsPrinter;
import tech.allegro.schema.json2avro.converter.UnknownFieldListener;
import tech.allegro.schema.json2avro.converter.types.AvroTypeConverterWithStrictJavaTypeCheck;

public class RecordConverter
extends AvroTypeConverterWithStrictJavaTypeCheck<Map> {
    private final JsonToAvroReader jsonToAvroReader;
    private final UnknownFieldListener unknownFieldListener;

    public RecordConverter(JsonToAvroReader jsonToAvroReader, UnknownFieldListener unknownFieldListener) {
        super(Map.class);
        this.jsonToAvroReader = jsonToAvroReader;
        this.unknownFieldListener = unknownFieldListener;
    }

    @Override
    public Object convertValue(Schema.Field field, Schema schema, Map jsonValue, Deque<String> path, boolean silently) {
        RecordBuilderBase<GenericData.Record> builder = this.createRecordBuilder(schema);
        jsonValue.forEach((key, value) -> {
            Schema.Field subField = schema.getField(key);
            if (subField != null) {
                Object fieldValue = this.jsonToAvroReader.read(subField, subField.schema(), value, path, false);
                this.setField(builder, subField, fieldValue);
            } else if (this.unknownFieldListener != null) {
                this.unknownFieldListener.onUnknownField((String)key, value, PathsPrinter.print(path, key));
            }
        });
        return builder.build();
    }

    protected RecordBuilderBase<GenericData.Record> createRecordBuilder(Schema schema) {
        return new GenericRecordBuilder(schema);
    }

    protected void setField(RecordBuilderBase<GenericData.Record> builder, Schema.Field subField, Object fieldValue) {
        ((GenericRecordBuilder)builder).set(subField, fieldValue);
    }

    @Override
    public boolean canManage(Schema schema, Deque<String> path) {
        return schema.getType().equals((Object)Schema.Type.RECORD);
    }
}

