/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.utils;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.asterix.om.base.ABoolean;
import org.apache.asterix.om.base.AMissing;
import org.apache.asterix.om.base.ANull;
import org.apache.asterix.om.base.AOrderedList;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.ConstantExpressionUtil;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.functions.AlgebricksBuiltinFunctions;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;

public class PushdownUtil {
    public static final Set<FunctionIdentifier> YIELDABLE_FUNCTIONS = PushdownUtil.createYieldableFunctions();
    public static final Set<FunctionIdentifier> ARRAY_FUNCTIONS = PushdownUtil.createSupportedArrayFunctions();
    public static final Set<FunctionIdentifier> SUPPORTED_FUNCTIONS = PushdownUtil.createSupportedFunctions();
    public static final Set<FunctionIdentifier> FILTER_PUSHABLE_PATH_FUNCTIONS = PushdownUtil.createFilterPushablePathFunctions();
    public static final Set<FunctionIdentifier> COMPARE_FUNCTIONS = PushdownUtil.createCompareFunctions();
    public static final Set<FunctionIdentifier> RANGE_FILTER_PUSHABLE_FUNCTIONS = PushdownUtil.createRangeFilterPushableFunctions();
    public static final Set<FunctionIdentifier> FILTER_PUSHABLE_AGGREGATE_FUNCTIONS = PushdownUtil.createFilterPushableAggregateFunctions();
    public static final Set<FunctionIdentifier> FILTER_PROHIBITED_FUNCTIONS = PushdownUtil.createFilterProhibitedFunctions();

    private PushdownUtil() {
    }

    public static IVariableTypeEnvironment getTypeEnv(ILogicalOperator useOperator, IOptimizationContext context) throws AlgebricksException {
        if (useOperator.getOperatorTag() == LogicalOperatorTag.DATASOURCESCAN || useOperator.getOperatorTag() == LogicalOperatorTag.INNERJOIN) {
            return useOperator.computeOutputTypeEnvironment((ITypingContext)context);
        }
        return useOperator.computeInputTypeEnvironment((ITypingContext)context);
    }

    public static IVariableTypeEnvironment getTypeEnv(ILogicalOperator useOperator, ILogicalOperator scanOperator, IOptimizationContext context) throws AlgebricksException {
        if (useOperator == scanOperator) {
            return useOperator.computeOutputTypeEnvironment((ITypingContext)context);
        }
        return scanOperator.computeOutputTypeEnvironment((ITypingContext)context);
    }

    public static String getFieldName(AbstractFunctionCallExpression fieldAccessExpr, IVariableTypeEnvironment typeEnv) throws AlgebricksException {
        if (BuiltinFunctions.FIELD_ACCESS_BY_NAME.equals((Object)fieldAccessExpr.getFunctionIdentifier())) {
            return ConstantExpressionUtil.getStringArgument((AbstractFunctionCallExpression)fieldAccessExpr, (int)1);
        }
        IAType type = (IAType)typeEnv.getType((ILogicalExpression)((Mutable)fieldAccessExpr.getArguments().get(0)).getValue());
        ARecordType recordType = PushdownUtil.getRecordType(type);
        int fieldIdx = ConstantExpressionUtil.getIntArgument((AbstractFunctionCallExpression)fieldAccessExpr, (int)1);
        return recordType.getFieldNames()[fieldIdx];
    }

    public static boolean isConstant(ILogicalExpression expression) {
        return expression.getExpressionTag() == LogicalExpressionTag.CONSTANT;
    }

    public static boolean isFilterPath(ILogicalExpression expression) {
        FunctionIdentifier fid = PushdownUtil.getFunctionIdentifier(expression);
        return fid != null && FILTER_PUSHABLE_PATH_FUNCTIONS.contains(fid);
    }

    public static boolean isCompare(ILogicalExpression expression) {
        FunctionIdentifier fid = PushdownUtil.getFunctionIdentifier(expression);
        return fid != null && COMPARE_FUNCTIONS.contains(fid);
    }

    public static boolean isAnd(ILogicalExpression expression) {
        FunctionIdentifier fid = PushdownUtil.getFunctionIdentifier(expression);
        return BuiltinFunctions.AND.equals((Object)fid);
    }

    public static boolean isOr(ILogicalExpression expression) {
        FunctionIdentifier fid = PushdownUtil.getFunctionIdentifier(expression);
        return BuiltinFunctions.OR.equals((Object)fid);
    }

    public static boolean isNot(ILogicalExpression expression) {
        FunctionIdentifier fid = PushdownUtil.getFunctionIdentifier(expression);
        return BuiltinFunctions.NOT.equals((Object)fid);
    }

    public static AOrderedList getArrayConstantFromScanCollection(ILogicalExpression expression) {
        FunctionIdentifier fid = PushdownUtil.getFunctionIdentifier(expression);
        if (!BuiltinFunctions.SCAN_COLLECTION.equals((Object)fid)) {
            return null;
        }
        AbstractFunctionCallExpression funcExpr = (AbstractFunctionCallExpression)expression;
        ILogicalExpression argExpr = (ILogicalExpression)((Mutable)funcExpr.getArguments().get(0)).getValue();
        if (!PushdownUtil.isConstant(argExpr)) {
            return null;
        }
        IAObject constValue = PushdownUtil.getConstant(argExpr);
        return constValue.getType().getTypeTag() == ATypeTag.ARRAY ? (AOrderedList)constValue : null;
    }

    public static boolean isTypeFunction(FunctionIdentifier fid) {
        return fid.getName().startsWith("is");
    }

    public static boolean isNestedFunction(FunctionIdentifier fid) {
        return PushdownUtil.isObjectFunction(fid) || PushdownUtil.isArrayOrAggregateFunction(fid) || BuiltinFunctions.DEEP_EQUAL.equals((Object)fid);
    }

    public static boolean isObjectFunction(FunctionIdentifier fid) {
        String functionName = fid.getName();
        return functionName.contains("object") || BuiltinFunctions.PAIRS.equals((Object)fid);
    }

    public static boolean isArrayOrAggregateFunction(FunctionIdentifier fid) {
        String functionName = fid.getName();
        return functionName.startsWith("array") || functionName.startsWith("strict") || functionName.startsWith("sql") || BuiltinFunctions.GET_ITEM.equals((Object)fid) || BuiltinFunctions.isBuiltinScalarAggregateFunction((FunctionIdentifier)fid) || BuiltinFunctions.isBuiltinAggregateFunction((FunctionIdentifier)fid);
    }

    public static boolean isSameFunction(ILogicalExpression expr1, ILogicalExpression expr2) {
        FunctionIdentifier fid1 = PushdownUtil.getFunctionIdentifier(expr1);
        FunctionIdentifier fid2 = PushdownUtil.getFunctionIdentifier(expr2);
        return fid1 != null && fid1.equals((Object)fid2);
    }

    public static boolean isAllVariableExpressions(List<Mutable<ILogicalExpression>> arguments) {
        return arguments.stream().allMatch(arg -> ((ILogicalExpression)arg.getValue()).getExpressionTag() == LogicalExpressionTag.VARIABLE);
    }

    public static boolean isSupportedFilterAggregateFunction(ILogicalExpression expression) {
        FunctionIdentifier fid = PushdownUtil.getFunctionIdentifier(expression);
        return fid != null && FILTER_PUSHABLE_AGGREGATE_FUNCTIONS.contains(fid);
    }

    public static boolean isProhibitedFilterFunction(ILogicalExpression expression) {
        FunctionIdentifier fid = PushdownUtil.getFunctionIdentifier(expression);
        return fid != null && !RANGE_FILTER_PUSHABLE_FUNCTIONS.contains(fid) && (PushdownUtil.isNestedFunction(fid) || PushdownUtil.isTypeFunction(fid) || FILTER_PROHIBITED_FUNCTIONS.contains(fid));
    }

    public static IAObject getConstant(ILogicalExpression expr) {
        IAlgebricksConstantValue algebricksConstant = ((ConstantExpression)expr).getValue();
        if (algebricksConstant.isTrue()) {
            return ABoolean.TRUE;
        }
        if (algebricksConstant.isFalse()) {
            return ABoolean.FALSE;
        }
        if (algebricksConstant.isMissing()) {
            return AMissing.MISSING;
        }
        if (algebricksConstant.isNull()) {
            return ANull.NULL;
        }
        return ((AsterixConstantValue)algebricksConstant).getObject();
    }

    private static FunctionIdentifier getFunctionIdentifier(ILogicalExpression expression) {
        if (expression.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return null;
        }
        AbstractFunctionCallExpression funcExpr = (AbstractFunctionCallExpression)expression;
        return funcExpr.getFunctionIdentifier();
    }

    private static Set<FunctionIdentifier> createSupportedArrayFunctions() {
        return Set.of(BuiltinFunctions.GET_ITEM, BuiltinFunctions.ARRAY_STAR, BuiltinFunctions.SCAN_COLLECTION);
    }

    private static ARecordType getRecordType(IAType type) {
        IAType recordType = type;
        if (type.getTypeTag() == ATypeTag.UNION) {
            recordType = ((AUnionType)type).getActualType();
        }
        return (ARecordType)recordType;
    }

    private static Set<FunctionIdentifier> createSupportedFunctions() {
        HashSet<FunctionIdentifier> supportedFunctions = new HashSet<FunctionIdentifier>();
        supportedFunctions.add(BuiltinFunctions.FIELD_ACCESS_BY_NAME);
        supportedFunctions.add(BuiltinFunctions.FIELD_ACCESS_BY_INDEX);
        supportedFunctions.addAll(ARRAY_FUNCTIONS);
        return supportedFunctions;
    }

    private static Set<FunctionIdentifier> createYieldableFunctions() {
        return Set.of(BuiltinFunctions.IS_ARRAY, BuiltinFunctions.IS_MULTISET, BuiltinFunctions.IS_OBJECT, BuiltinFunctions.IS_ATOMIC, BuiltinFunctions.IS_BINARY, BuiltinFunctions.IS_POINT, BuiltinFunctions.IS_LINE, BuiltinFunctions.IS_RECTANGLE, BuiltinFunctions.IS_CIRCLE, BuiltinFunctions.IS_POLYGON, BuiltinFunctions.IS_SPATIAL, BuiltinFunctions.IS_DATE, BuiltinFunctions.IS_DATETIME, BuiltinFunctions.IS_TIME, BuiltinFunctions.IS_DURATION, BuiltinFunctions.IS_INTERVAL, BuiltinFunctions.IS_TEMPORAL, BuiltinFunctions.IS_UUID, BuiltinFunctions.IS_NUMBER, BuiltinFunctions.IS_BOOLEAN, BuiltinFunctions.IS_STRING, BuiltinFunctions.IS_SYSTEM_NULL, AlgebricksBuiltinFunctions.IS_MISSING, AlgebricksBuiltinFunctions.IS_NULL, BuiltinFunctions.IS_UNKNOWN, BuiltinFunctions.GET_TYPE, BuiltinFunctions.SCALAR_SQL_COUNT);
    }

    private static Set<FunctionIdentifier> createFilterPushablePathFunctions() {
        HashSet<FunctionIdentifier> pushablePathFunctions = new HashSet<FunctionIdentifier>(SUPPORTED_FUNCTIONS);
        pushablePathFunctions.remove(BuiltinFunctions.GET_ITEM);
        return pushablePathFunctions;
    }

    private static Set<FunctionIdentifier> createCompareFunctions() {
        return Set.of(AlgebricksBuiltinFunctions.LE, AlgebricksBuiltinFunctions.GE, AlgebricksBuiltinFunctions.LT, AlgebricksBuiltinFunctions.GT, AlgebricksBuiltinFunctions.EQ);
    }

    private static Set<FunctionIdentifier> createRangeFilterPushableFunctions() {
        HashSet<FunctionIdentifier> pushableFunctions = new HashSet<FunctionIdentifier>(COMPARE_FUNCTIONS);
        pushableFunctions.add(AlgebricksBuiltinFunctions.AND);
        pushableFunctions.add(AlgebricksBuiltinFunctions.OR);
        pushableFunctions.add(AlgebricksBuiltinFunctions.NOT);
        return pushableFunctions;
    }

    private static Set<FunctionIdentifier> createFilterPushableAggregateFunctions() {
        HashSet<FunctionIdentifier> pushableFunctions = new HashSet<FunctionIdentifier>();
        pushableFunctions.add(BuiltinFunctions.NON_EMPTY_STREAM);
        return pushableFunctions;
    }

    private static Set<FunctionIdentifier> createFilterProhibitedFunctions() {
        HashSet<FunctionIdentifier> prohibitedFunctions = new HashSet<FunctionIdentifier>();
        prohibitedFunctions.add(BuiltinFunctions.EMPTY_STREAM);
        return prohibitedFunctions;
    }
}

