/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.jdbc;

import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.asterix.jdbc.ADBProtocol;
import org.apache.asterix.jdbc.core.ADBDriverBase;
import org.apache.asterix.jdbc.core.ADBDriverContext;
import org.apache.asterix.jdbc.core.ADBDriverProperty;
import org.apache.asterix.jdbc.core.ADBErrorReporter;
import org.apache.asterix.jdbc.core.ADBProductVersion;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;

public class Driver
extends ADBDriverBase
implements java.sql.Driver {
    private static final String DRIVER_SCHEME = "asterixdb:";
    private static final int DEFAULT_API_PORT = 19002;

    public Driver() {
        super(DRIVER_SCHEME, 19002);
    }

    @Override
    protected ADBProtocol createProtocol(String host, int port, Map<ADBDriverProperty, Object> properties, ADBDriverContext driverContext) throws SQLException {
        int loginTimeoutSeconds = DriverManager.getLoginTimeout();
        return new ADBProtocol(host, port, properties, driverContext, loginTimeoutSeconds);
    }

    @Override
    protected Properties getURIParameters(URI uri) {
        List<NameValuePair> params = URLEncodedUtils.parse(uri, StandardCharsets.UTF_8);
        if (params.isEmpty()) {
            return null;
        }
        Properties properties = new Properties();
        for (NameValuePair pair : params) {
            properties.setProperty(pair.getName(), pair.getValue());
        }
        return properties;
    }

    @Override
    protected ADBErrorReporter createErrorReporter() {
        return new ADBErrorReporter(){

            @Override
            protected boolean isTimeoutConnectionError(IOException e) {
                return this.isInstanceOf(e, ADBProtocol.TIMEOUT_CONNECTION_ERRORS);
            }

            @Override
            protected boolean isTransientConnectionError(IOException e) {
                return this.isInstanceOf(e, ADBProtocol.TRANSIENT_CONNECTION_ERRORS);
            }
        };
    }

    @Override
    protected ADBProductVersion getDriverVersion() {
        Package driverPackage = this.getClass().getPackage();
        return Driver.parseDriverVersion(driverPackage.getImplementationTitle(), driverPackage.getImplementationVersion());
    }

    private static ADBProductVersion parseDriverVersion(String productName, String productVersion) {
        int majorVersion = 0;
        int minorVersion = 0;
        if (productVersion != null) {
            String[] v = productVersion.split("\\.");
            try {
                majorVersion = Integer.parseInt(v[0]);
                if (v.length > 1) {
                    minorVersion = Integer.parseInt(v[1]);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new ADBProductVersion(productName, productVersion, majorVersion, minorVersion);
    }

    static {
        Driver.setupLogging(Driver.class);
        Driver.registerDriver(new Driver());
    }
}

