/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.format;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.activation.DataSource;
import org.apache.axis2.format.ManagedDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ManagedDataSourceFactory {
    public static ManagedDataSource create(DataSource ds) {
        Class<?>[] orgIfaces = ds.getClass().getInterfaces();
        Class[] ifaces = new Class[orgIfaces.length + 1];
        ifaces[0] = ManagedDataSource.class;
        System.arraycopy(orgIfaces, 0, ifaces, 1, orgIfaces.length);
        return (ManagedDataSource)Proxy.newProxyInstance(ManagedDataSourceFactory.class.getClassLoader(), ifaces, (InvocationHandler)new DataSourceManager(ds));
    }

    private static class DataSourceManager
    implements InvocationHandler {
        private static final Log log = LogFactory.getLog(DataSourceManager.class);
        private static final Method getInputStreamMethod;
        private static final Method destroyMethod;
        private final DataSource dataSource;
        private final List<ManagedInputStream> openStreams = Collections.synchronizedList(new LinkedList());

        public DataSourceManager(DataSource dataSource) {
            this.dataSource = dataSource;
        }

        public void notifyStreamClosed(ManagedInputStream managedInputStream) {
            if (!this.openStreams.remove(managedInputStream)) {
                throw new IllegalStateException();
            }
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                if (method.equals(getInputStreamMethod)) {
                    InputStream in = (InputStream)method.invoke((Object)this.dataSource, args);
                    ManagedInputStream in2 = new ManagedInputStream(this, in);
                    this.openStreams.add(in2);
                    return in2;
                }
                if (method.equals(destroyMethod)) {
                    while (!this.openStreams.isEmpty()) {
                        try {
                            this.openStreams.get(0).close();
                        }
                        catch (IOException ex) {
                            log.warn((Object)"Exception when closing open stream from managed data source", (Throwable)ex);
                        }
                    }
                    return null;
                }
                return method.invoke((Object)this.dataSource, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getCause();
            }
        }

        static {
            try {
                getInputStreamMethod = DataSource.class.getMethod("getInputStream", new Class[0]);
                destroyMethod = ManagedDataSource.class.getMethod("destroy", new Class[0]);
            }
            catch (NoSuchMethodException ex) {
                throw new NoSuchMethodError(ex.getMessage());
            }
        }
    }

    private static class ManagedInputStream
    extends FilterInputStream {
        private DataSourceManager manager;

        public ManagedInputStream(DataSourceManager manager, InputStream parent) {
            super(parent);
            this.manager = manager;
        }

        @Override
        public void close() throws IOException {
            if (this.manager != null) {
                this.manager.notifyStreamClosed(this);
                this.manager = null;
            }
            super.close();
        }
    }
}

