/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.elasticstack.functions;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.elasticstack.domain.DriveInfo;
import org.jclouds.elasticstack.functions.ListOfKeyValuesDelimitedByBlankLinesToDriveInfoSet;
import org.jclouds.http.HttpResponse;

@Singleton
public class KeyValuesDelimitedByBlankLinesToDriveInfo
implements Function<HttpResponse, DriveInfo> {
    private final ListOfKeyValuesDelimitedByBlankLinesToDriveInfoSet setParser;

    @Inject
    public KeyValuesDelimitedByBlankLinesToDriveInfo(ListOfKeyValuesDelimitedByBlankLinesToDriveInfoSet setParser) {
        this.setParser = setParser;
    }

    public DriveInfo apply(HttpResponse response) {
        Set<DriveInfo> drives = this.setParser.apply(response);
        if (drives.isEmpty()) {
            return null;
        }
        return (DriveInfo)Iterables.get(drives, (int)0);
    }
}

