/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.feed.http;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteStreams;
import com.google.common.reflect.TypeToken;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.MachineLocation;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.feed.AbstractFeed;
import org.apache.brooklyn.core.feed.AttributePollHandler;
import org.apache.brooklyn.core.feed.DelegatingPollHandler;
import org.apache.brooklyn.core.feed.Poller;
import org.apache.brooklyn.core.location.Locations;
import org.apache.brooklyn.core.location.Machines;
import org.apache.brooklyn.core.location.internal.LocationInternal;
import org.apache.brooklyn.feed.http.HttpPollConfig;
import org.apache.brooklyn.util.executor.HttpExecutorFactory;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.http.HttpToolResponse;
import org.apache.brooklyn.util.http.auth.UsernamePassword;
import org.apache.brooklyn.util.http.executor.HttpConfig;
import org.apache.brooklyn.util.http.executor.HttpExecutor;
import org.apache.brooklyn.util.http.executor.HttpRequest;
import org.apache.brooklyn.util.http.executor.HttpResponse;
import org.apache.brooklyn.util.http.executor.apacheclient.HttpExecutorImpl;
import org.apache.brooklyn.util.stream.Streams;
import org.apache.brooklyn.util.time.Duration;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpFeed
extends AbstractFeed {
    public static final Logger log = LoggerFactory.getLogger(HttpFeed.class);
    public static final ConfigKey<SetMultimap<HttpPollIdentifier, HttpPollConfig<?>>> POLLS = ConfigKeys.newConfigKey(new TypeToken<SetMultimap<HttpPollIdentifier, HttpPollConfig<?>>>(){}, "polls");

    public static Builder builder() {
        return new Builder();
    }

    public HttpFeed() {
    }

    protected HttpFeed(Builder builder) {
        HttpExecutor httpExecutor;
        this.config().set(ONLY_IF_SERVICE_UP, builder.onlyIfServiceUp);
        Map<String, String> baseHeaders = builder.buildBaseHeaders();
        if (builder.httpExecutor != null) {
            httpExecutor = builder.httpExecutor;
        } else {
            HttpExecutorFactory httpExecutorFactory = null;
            Collection<? extends Location> locations = Locations.getLocationsCheckingAncestors(builder.entity.getLocations(), builder.entity);
            Maybe<MachineLocation> location = Machines.findUniqueElement(locations, MachineLocation.class);
            if (location.isPresent() && ((MachineLocation)location.get()).hasExtension(HttpExecutorFactory.class)) {
                httpExecutorFactory = (HttpExecutorFactory)((MachineLocation)location.get()).getExtension(HttpExecutorFactory.class);
                Map<String, Object> httpExecutorProps = ((LocationInternal)location.get()).config().getBag().getAllConfig();
                httpExecutor = httpExecutorFactory.getHttpExecutor(httpExecutorProps);
            } else {
                httpExecutor = HttpExecutorImpl.newInstance();
            }
        }
        HashMultimap polls = HashMultimap.create();
        for (HttpPollConfig config : builder.polls) {
            if (!config.isEnabled()) continue;
            HttpPollConfig configCopy = new HttpPollConfig(config);
            if (configCopy.getPeriod() < 0L) {
                configCopy.period(builder.period);
            }
            String method = config.getMethod();
            Map<String, String> headers = config.buildHeaders(baseHeaders);
            byte[] body = config.getBody();
            Duration connectionTimeout = config.getConnectionTimeout();
            Duration socketTimeout = config.getSocketTimeout();
            Optional credentials = Optional.fromNullable((Object)builder.credentials);
            Supplier baseUriProvider = builder.baseUriProvider;
            if (builder.baseUri != null) {
                if (baseUriProvider != null) {
                    throw new IllegalStateException("Not permitted to supply baseUri and baseUriProvider");
                }
                ImmutableMap baseUriVars = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull((Object)builder.baseUriVars, (Object)"baseUriVars")));
                URI uri = config.buildUri(builder.baseUri, (Map<String, String>)baseUriVars);
                baseUriProvider = Suppliers.ofInstance((Object)uri);
            } else if (!builder.baseUriVars.isEmpty()) {
                throw new IllegalStateException("Not permitted to supply URI vars when using a URI provider; pass the vars to the provider instead");
            }
            Preconditions.checkNotNull((Object)baseUriProvider);
            polls.put((Object)new HttpPollIdentifier(httpExecutor, method, baseUriProvider, headers, body, credentials, connectionTimeout, socketTimeout), configCopy);
        }
        this.config().set(POLLS, polls);
        this.initUniqueTag(builder.uniqueTag, polls.values());
    }

    @Override
    protected void preStart() {
        SetMultimap<HttpPollIdentifier, HttpPollConfig<?>> polls = this.getConfig(POLLS);
        for (final HttpPollIdentifier pollInfo : polls.keySet()) {
            Set configs = polls.get((Object)pollInfo);
            long minPeriod = Integer.MAX_VALUE;
            LinkedHashSet handlers = Sets.newLinkedHashSet();
            for (HttpPollConfig config : configs) {
                handlers.add(new AttributePollHandler(config, (Entity)this.entity, this));
                if (config.getPeriod() <= 0L) continue;
                minPeriod = Math.min(minPeriod, config.getPeriod());
            }
            Callable<HttpToolResponse> pollJob = new Callable<HttpToolResponse>(){

                @Override
                public HttpToolResponse call() throws Exception {
                    if (log.isTraceEnabled()) {
                        log.trace("http polling for {} sensors at {}", (Object)HttpFeed.this.entity, (Object)pollInfo);
                    }
                    UsernamePassword creds = null;
                    if (pollInfo.credentials.isPresent()) {
                        creds = new UsernamePassword(((Credentials)pollInfo.credentials.get()).getUserPrincipal().getName(), ((Credentials)pollInfo.credentials.get()).getPassword());
                    }
                    HttpResponse response = pollInfo.httpExecutor.execute(new HttpRequest.Builder().headers(pollInfo.headers).uri((URI)pollInfo.uriProvider.get()).credentials((org.apache.brooklyn.util.http.auth.Credentials)creds).method(pollInfo.method).body(pollInfo.body).config(HttpConfig.builder().trustSelfSigned(true).trustAll(true).laxRedirect(true).build()).build());
                    return HttpFeed.this.createHttpToolRespose(response);
                }
            };
            this.getPoller().scheduleAtFixedRate(pollJob, new DelegatingPollHandler(handlers), minPeriod);
        }
    }

    protected Poller<HttpToolResponse> getPoller() {
        return super.getPoller();
    }

    private HttpToolResponse createHttpToolRespose(HttpResponse response) throws IOException {
        int responseCode = response.code();
        Map headers = response.headers().asMap();
        byte[] content = null;
        long startTime = System.currentTimeMillis();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        long durationMillisOfFirstResponse = Duration.sinceUtc((long)startTime).toMilliseconds();
        try {
            ByteStreams.copy((InputStream)response.getContent(), (OutputStream)out);
            content = out.toByteArray();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            Streams.closeQuietly((Closeable)out);
        }
        long durationMillisOfFullContent = Duration.sinceUtc((long)startTime).toMilliseconds();
        return new HttpToolResponse(responseCode, headers, content, startTime, durationMillisOfFirstResponse, durationMillisOfFullContent);
    }

    private static class HttpPollIdentifier {
        final HttpExecutor httpExecutor;
        final String method;
        final Supplier<URI> uriProvider;
        final Map<String, String> headers;
        final byte[] body;
        final Optional<Credentials> credentials;
        final Duration connectionTimeout;
        final Duration socketTimeout;

        private HttpPollIdentifier(HttpExecutor httpExecutor, String method, Supplier<URI> uriProvider, Map<String, String> headers, byte[] body, Optional<Credentials> credentials, Duration connectionTimeout, Duration socketTimeout) {
            this.httpExecutor = httpExecutor;
            this.method = ((String)Preconditions.checkNotNull((Object)method, (Object)"method")).toLowerCase();
            this.uriProvider = (Supplier)Preconditions.checkNotNull(uriProvider, (Object)"uriProvider");
            this.headers = (Map)Preconditions.checkNotNull(headers, (Object)"headers");
            this.body = body;
            this.credentials = (Optional)Preconditions.checkNotNull(credentials, (Object)"credentials");
            this.connectionTimeout = connectionTimeout;
            this.socketTimeout = socketTimeout;
            if (!this.method.equals("get") && !this.method.equals("post")) {
                throw new IllegalArgumentException("Unsupported HTTP method (only supports GET and POST): " + method);
            }
            if (body != null && method.equalsIgnoreCase("get")) {
                throw new IllegalArgumentException("Must not set body for http GET method");
            }
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.method, this.uriProvider, this.headers, this.body, this.credentials});
        }

        public boolean equals(Object other) {
            if (!(other instanceof HttpPollIdentifier)) {
                return false;
            }
            HttpPollIdentifier o = (HttpPollIdentifier)other;
            return Objects.equal((Object)this.method, (Object)o.method) && Objects.equal(this.uriProvider, o.uriProvider) && Objects.equal(this.headers, o.headers) && Objects.equal((Object)this.body, (Object)o.body) && Objects.equal((Object)this.httpExecutor, (Object)o.httpExecutor) && Objects.equal(this.credentials, o.credentials);
        }
    }

    public static class Builder {
        private Entity entity;
        private boolean onlyIfServiceUp = false;
        private Supplier<URI> baseUriProvider;
        private Duration period = Duration.millis((Number)500);
        private List<HttpPollConfig<?>> polls = Lists.newArrayList();
        private URI baseUri;
        private Map<String, String> baseUriVars = Maps.newLinkedHashMap();
        private Map<String, String> headers = Maps.newLinkedHashMap();
        private boolean suspended = false;
        private Credentials credentials;
        private String uniqueTag;
        private HttpExecutor httpExecutor;
        private Boolean preemptiveBasicAuth;
        private volatile boolean built;

        public Builder entity(Entity val) {
            this.entity = val;
            return this;
        }

        public Builder onlyIfServiceUp() {
            return this.onlyIfServiceUp(true);
        }

        public Builder onlyIfServiceUp(boolean onlyIfServiceUp) {
            this.onlyIfServiceUp = onlyIfServiceUp;
            return this;
        }

        public Builder baseUri(Supplier<URI> val) {
            if (this.baseUri != null && val != null) {
                throw new IllegalStateException("Builder cannot take both a URI and a URI Provider");
            }
            this.baseUriProvider = val;
            return this;
        }

        public Builder baseUri(URI val) {
            if (this.baseUriProvider != null && val != null) {
                throw new IllegalStateException("Builder cannot take both a URI and a URI Provider");
            }
            this.baseUri = val;
            return this;
        }

        public Builder baseUrl(URL val) {
            return this.baseUri(URI.create(val.toString()));
        }

        public Builder baseUri(String val) {
            return this.baseUri(URI.create(val));
        }

        public Builder baseUriVars(Map<String, String> vals) {
            this.baseUriVars.putAll(vals);
            return this;
        }

        public Builder baseUriVar(String key, String val) {
            this.baseUriVars.put(key, val);
            return this;
        }

        public Builder headers(Map<String, String> vals) {
            this.headers.putAll(vals);
            return this;
        }

        public Builder header(String key, String val) {
            this.headers.put(key, val);
            return this;
        }

        public Builder period(Duration duration) {
            this.period = duration;
            return this;
        }

        public Builder period(long millis) {
            return this.period(millis, TimeUnit.MILLISECONDS);
        }

        public Builder period(long val, TimeUnit units) {
            return this.period(Duration.of((long)val, (TimeUnit)units));
        }

        public Builder poll(HttpPollConfig<?> config) {
            this.polls.add(config);
            return this;
        }

        public Builder suspended() {
            return this.suspended(true);
        }

        public Builder suspended(boolean startsSuspended) {
            this.suspended = startsSuspended;
            return this;
        }

        public Builder credentials(String username, String password) {
            this.credentials = new UsernamePasswordCredentials(username, password);
            return this;
        }

        public Builder credentialsIfNotNull(String username, String password) {
            if (username != null && password != null) {
                this.credentials = new UsernamePasswordCredentials(username, password);
            }
            return this;
        }

        public Builder preemptiveBasicAuth(Boolean val) {
            this.preemptiveBasicAuth = val;
            return this;
        }

        public Builder uniqueTag(String uniqueTag) {
            this.uniqueTag = uniqueTag;
            return this;
        }

        public Builder httpExecutor(HttpExecutor val) {
            this.httpExecutor = val;
            return this;
        }

        public Map<String, String> buildBaseHeaders() {
            if (Boolean.TRUE.equals(this.preemptiveBasicAuth)) {
                Credentials creds = this.credentials;
                if (creds == null) {
                    throw new IllegalArgumentException("Must not enable preemptiveBasicAuth when there are no credentials, in feed for " + this.baseUri);
                }
                String username = (String)Preconditions.checkNotNull((Object)creds.getUserPrincipal().getName(), (Object)"username");
                if (username == null) {
                    throw new IllegalArgumentException("Must not enable preemptiveBasicAuth when username is null, in feed for " + this.baseUri);
                }
                if (username.contains(":")) {
                    throw new IllegalArgumentException("Username must not contain colon when preemptiveBasicAuth is enabled, in feed for " + this.baseUri);
                }
                String password = creds.getPassword();
                String toencode = username + ":" + (password == null ? "" : password);
                String headerVal = "Basic " + BaseEncoding.base64().encode(toencode.getBytes(StandardCharsets.UTF_8));
                return ImmutableMap.builder().put((Object)"Authorization", (Object)headerVal).putAll((Map)Preconditions.checkNotNull(this.headers, (Object)"headers")).build();
            }
            return ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(this.headers, (Object)"headers")));
        }

        public HttpFeed build() {
            this.built = true;
            HttpFeed result = new HttpFeed(this);
            result.setEntity((EntityLocal)Preconditions.checkNotNull((Object)((EntityLocal)this.entity), (Object)"entity"));
            if (this.suspended) {
                result.suspend();
            }
            result.start();
            return result;
        }

        protected void finalize() {
            if (!this.built) {
                log.warn("HttpFeed.Builder created, but build() never called");
            }
        }
    }
}

