/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.xml;

import com.google.common.base.Supplier;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.ec2.domain.InstanceState;
import org.jclouds.ec2.domain.InstanceStateChange;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.location.Region;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.xml.sax.Attributes;

public class InstanceStateChangeHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<Set<InstanceStateChange>> {
    private StringBuilder currentText = new StringBuilder();
    @Inject
    @Region
    Supplier<String> defaultRegion;
    Set<InstanceStateChange> instances = Sets.newLinkedHashSet();
    private InstanceState shutdownState;
    private InstanceState previousState;
    private String instanceId;
    private boolean inCurrentState;
    private boolean inPreviousState;

    public Set<InstanceStateChange> getResult() {
        return this.instances;
    }

    public void startElement(String uri, String name, String qName, Attributes attrs) {
        if (qName.equals("shutdownState") || qName.equals("currentState")) {
            this.inCurrentState = true;
        } else if (qName.equals("previousState")) {
            this.inPreviousState = true;
        }
    }

    public void endElement(String uri, String name, String qName) {
        if (qName.equals("instanceId")) {
            this.instanceId = this.currentOrNull();
        } else if (qName.equals("shutdownState") || qName.equals("currentState")) {
            this.inCurrentState = false;
        } else if (qName.equals("previousState")) {
            this.inPreviousState = false;
        } else if (qName.equals("name")) {
            if (this.inCurrentState) {
                this.shutdownState = InstanceState.fromValue(this.currentOrNull());
            } else if (this.inPreviousState) {
                this.previousState = InstanceState.fromValue(this.currentOrNull());
            }
        } else if (qName.equals("item")) {
            String region = AWSUtils.findRegionInArgsOrNull((GeneratedHttpRequest)this.getRequest());
            if (region == null) {
                region = (String)this.defaultRegion.get();
            }
            this.instances.add(new InstanceStateChange(region, this.instanceId, this.shutdownState, this.previousState));
            this.instanceId = null;
            this.shutdownState = null;
            this.previousState = null;
        }
        this.currentText.setLength(0);
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }

    protected String currentOrNull() {
        String returnVal = this.currentText.toString().trim();
        return returnVal.equals("") ? null : returnVal;
    }
}

