/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.feed.jmx;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxValueFunctions {
    private static final Logger log = LoggerFactory.getLogger(JmxValueFunctions.class);

    @Deprecated
    private static Function<TabularData, Map> tabularDataToMapOld() {
        return new Function<TabularData, Map>(){

            public Map apply(TabularData input) {
                return JmxValueFunctions.tabularDataToMap(input);
            }
        };
    }

    @Deprecated
    private static Function<TabularData, Map> tabularDataToMapOfMapsOld() {
        return new Function<TabularData, Map>(){

            public Map apply(TabularData input) {
                return JmxValueFunctions.tabularDataToMapOfMaps(input);
            }
        };
    }

    @Deprecated
    private static Function<CompositeData, Map> compositeDataToMapOld() {
        return new Function<CompositeData, Map>(){

            public Map apply(CompositeData input) {
                return JmxValueFunctions.compositeDataToMap(input);
            }
        };
    }

    public static Function<TabularData, Map> tabularDataToMap() {
        return new TabularDataToMap();
    }

    public static Function<TabularData, Map> tabularDataToMapOfMaps() {
        return new TabularDataToMapOfMaps();
    }

    public static Function<CompositeData, Map> compositeDataToMap() {
        return new CompositeDataToMap();
    }

    public static Map tabularDataToMap(TabularData table) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (Object entry : table.values()) {
            CompositeData data = (CompositeData)entry;
            for (String key : data.getCompositeType().keySet()) {
                Object old = result.put(key, data.get(key));
                if (old == null) continue;
                log.warn("tablularDataToMap has overwritten key {}", (Object)key);
            }
        }
        return result;
    }

    public static Map<List<?>, Map<String, Object>> tabularDataToMapOfMaps(TabularData table) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (Object k : table.keySet()) {
            Object[] kValues = ((List)k).toArray();
            CompositeData v = table.get(kValues);
            result.put((List)k, JmxValueFunctions.compositeDataToMap(v));
        }
        return result;
    }

    public static Map<String, Object> compositeDataToMap(CompositeData data) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (String key : data.getCompositeType().keySet()) {
            Object old = result.put(key, data.get(key));
            if (old == null) continue;
            log.warn("compositeDataToMap has overwritten key {}", (Object)key);
        }
        return result;
    }

    protected static class CompositeDataToMap
    implements Function<CompositeData, Map> {
        protected CompositeDataToMap() {
        }

        public Map apply(CompositeData input) {
            return JmxValueFunctions.compositeDataToMap(input);
        }
    }

    protected static class TabularDataToMapOfMaps
    implements Function<TabularData, Map> {
        protected TabularDataToMapOfMaps() {
        }

        public Map apply(TabularData input) {
            return JmxValueFunctions.tabularDataToMapOfMaps(input);
        }
    }

    protected static class TabularDataToMap
    implements Function<TabularData, Map> {
        protected TabularDataToMap() {
        }

        public Map apply(TabularData input) {
            return JmxValueFunctions.tabularDataToMap(input);
        }
    }
}

