/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.policy.action;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableMap;
import java.util.Date;
import java.util.Map;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.apache.brooklyn.api.sensor.SensorEventListener;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.policy.action.AbstractScheduledEffectorPolicy;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class ScheduledEffectorPolicy
extends AbstractScheduledEffectorPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(ScheduledEffectorPolicy.class);
    public static final AttributeSensor<Boolean> INVOKE_IMMEDIATELY = Sensors.newBooleanSensor((String)"scheduler.invoke.now", (String)"Invoke the configured effector immediately when this becomes true");
    public static final AttributeSensor<Date> INVOKE_AT = Sensors.newSensor(Date.class, (String)"scheduler.invoke.at", (String)"Invoke the configured effector at this time");

    @Override
    public void setEntity(EntityLocal entity) {
        super.setEntity(entity);
        this.subscriptions().subscribe((Map)ImmutableMap.of((Object)"notifyOfInitialValue", (Object)true), (Entity)entity, INVOKE_IMMEDIATELY, (SensorEventListener)this);
        this.subscriptions().subscribe((Map)ImmutableMap.of((Object)"notifyOfInitialValue", (Object)true), (Entity)entity, INVOKE_AT, (SensorEventListener)this);
    }

    @Override
    public void start() {
        String time = (String)this.config().get(TIME);
        Duration wait = (Duration)this.config().get(WAIT);
        if (time != null) {
            wait = this.getWaitUntil(time);
        }
        if (wait != null) {
            this.schedule(wait);
        }
    }

    @Override
    public void onEvent(SensorEvent<Object> event) {
        super.onEvent(event);
        if (this.running.get()) {
            Boolean invoke;
            String time;
            if (event.getSensor().getName().equals(INVOKE_AT.getName()) && (time = (String)event.getValue()) != null) {
                this.schedule(this.getWaitUntil(time));
            }
            if (event.getSensor().getName().equals(INVOKE_IMMEDIATELY.getName()) && (invoke = Boolean.valueOf(Boolean.TRUE.equals(event.getValue()))).booleanValue()) {
                this.schedule(Duration.ZERO);
            }
        }
    }
}

