/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.ValidationUtils;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ServiceSpec;
import io.fabric8.kubernetes.api.model.ServiceSpecFluent;
import io.fabric8.kubernetes.api.model.ServiceSpecFluentImpl;

public class ServiceSpecBuilder
extends ServiceSpecFluentImpl<ServiceSpecBuilder>
implements VisitableBuilder<ServiceSpec, ServiceSpecBuilder> {
    ServiceSpecFluent<?> fluent;
    Boolean validationEnabled;

    public ServiceSpecBuilder() {
        this(true);
    }

    public ServiceSpecBuilder(Boolean validationEnabled) {
        this(new ServiceSpec(), validationEnabled);
    }

    public ServiceSpecBuilder(ServiceSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ServiceSpecBuilder(ServiceSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ServiceSpec(), validationEnabled);
    }

    public ServiceSpecBuilder(ServiceSpecFluent<?> fluent, ServiceSpec instance) {
        this(fluent, instance, true);
    }

    public ServiceSpecBuilder(ServiceSpecFluent<?> fluent, ServiceSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withClusterIP(instance.getClusterIP());
        fluent.withDeprecatedPublicIPs(instance.getDeprecatedPublicIPs());
        fluent.withExternalIPs(instance.getExternalIPs());
        fluent.withLoadBalancerIP(instance.getLoadBalancerIP());
        fluent.withLoadBalancerSourceRanges(instance.getLoadBalancerSourceRanges());
        fluent.withPortalIP(instance.getPortalIP());
        fluent.withPorts(instance.getPorts());
        fluent.withSelector(instance.getSelector());
        fluent.withSessionAffinity(instance.getSessionAffinity());
        fluent.withType(instance.getType());
        this.validationEnabled = validationEnabled;
    }

    public ServiceSpecBuilder(ServiceSpec instance) {
        this(instance, (Boolean)true);
    }

    public ServiceSpecBuilder(ServiceSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withClusterIP(instance.getClusterIP());
        this.withDeprecatedPublicIPs(instance.getDeprecatedPublicIPs());
        this.withExternalIPs(instance.getExternalIPs());
        this.withLoadBalancerIP(instance.getLoadBalancerIP());
        this.withLoadBalancerSourceRanges(instance.getLoadBalancerSourceRanges());
        this.withPortalIP(instance.getPortalIP());
        this.withPorts(instance.getPorts());
        this.withSelector(instance.getSelector());
        this.withSessionAffinity(instance.getSessionAffinity());
        this.withType(instance.getType());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ServiceSpec build() {
        ServiceSpec buildable = new ServiceSpec(this.fluent.getClusterIP(), this.fluent.getDeprecatedPublicIPs(), this.fluent.getExternalIPs(), this.fluent.getLoadBalancerIP(), this.fluent.getLoadBalancerSourceRanges(), this.fluent.getPortalIP(), this.fluent.getPorts(), this.fluent.getSelector(), this.fluent.getSessionAffinity(), this.fluent.getType());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceSpecBuilder that = (ServiceSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

