/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.client.Callback;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.LogWatch;
import io.fabric8.kubernetes.client.utils.InputStreamPumper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import okhttp3.Call;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogWatchCallback
implements LogWatch,
okhttp3.Callback,
AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogWatchCallback.class);
    private final OutputStream out;
    private final PipedInputStream output;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final ArrayBlockingQueue<Object> queue = new ArrayBlockingQueue(1);
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private InputStreamPumper pumper;

    public LogWatchCallback(OutputStream out) {
        this.out = out != null ? out : new PipedOutputStream();
        this.output = out != null ? null : new PipedInputStream();
    }

    @Override
    public void close() {
        this.pumper.close();
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(10L, TimeUnit.SECONDS)) {
                this.executorService.shutdownNow();
            }
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable(t);
        }
    }

    public void waitUntilReady() {
        try {
            Object obj = this.queue.poll(10L, TimeUnit.SECONDS);
            if (obj instanceof Boolean && ((Boolean)obj).booleanValue()) {
                return;
            }
            if (obj instanceof Throwable) {
                throw (Throwable)obj;
            }
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable(t);
        }
    }

    @Override
    public InputStream getOutput() {
        return this.output;
    }

    public void onFailure(Call call, IOException ioe) {
        LOGGER.error("Log Callback Failure.", (Throwable)ioe);
        if (!this.started.get()) {
            this.queue.add(ioe);
        }
    }

    public void onResponse(Call call, Response response) throws IOException {
        if (this.out instanceof PipedOutputStream && this.output != null) {
            this.output.connect((PipedOutputStream)this.out);
        }
        this.pumper = new InputStreamPumper(response.body().byteStream(), new Callback<byte[]>(){

            @Override
            public void call(byte[] input) {
                try {
                    LogWatchCallback.this.out.write(input);
                }
                catch (IOException e) {
                    throw KubernetesClientException.launderThrowable(e);
                }
            }
        });
        this.executorService.submit(this.pumper);
        this.started.set(true);
        this.queue.add(true);
    }
}

