/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecloudstorage.features;

import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.blobstore.BlobStoreFallbacks;
import org.jclouds.googlecloud.domain.ListPage;
import org.jclouds.googlecloudstorage.GoogleCloudStorageFallbacks;
import org.jclouds.googlecloudstorage.domain.Bucket;
import org.jclouds.googlecloudstorage.domain.templates.BucketTemplate;
import org.jclouds.googlecloudstorage.options.DeleteBucketOptions;
import org.jclouds.googlecloudstorage.options.GetBucketOptions;
import org.jclouds.googlecloudstorage.options.InsertBucketOptions;
import org.jclouds.googlecloudstorage.options.ListOptions;
import org.jclouds.googlecloudstorage.options.UpdateBucketOptions;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.oauth.v2.filters.OAuthFilter;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.PATCH;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.binders.BindToJsonPayload;

@SkipEncoding(value={47, 61})
@RequestFilters(value={OAuthFilter.class})
@Consumes(value={"application/json"})
public interface BucketApi {
    @Named(value="Bucket:get")
    @GET
    @Path(value="/b/{bucket}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean bucketExist(@PathParam(value="bucket") String var1);

    @Named(value="Bucket:get")
    @GET
    @Produces(value={"application/json"})
    @Path(value="/b/{bucket}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Bucket getBucket(@PathParam(value="bucket") String var1);

    @Named(value="Bucket:get")
    @GET
    @Produces(value={"application/json"})
    @Path(value="/b/{bucket}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Bucket getBucket(@PathParam(value="bucket") String var1, GetBucketOptions var2);

    @Named(value="Bucket:insert")
    @POST
    @Path(value="/b")
    @Fallback(value=GoogleCloudStorageFallbacks.NullOnBucketAlreadyExists.class)
    public Bucket createBucket(@QueryParam(value="project") String var1, @BinderParam(value=BindToJsonPayload.class) BucketTemplate var2);

    @Named(value="Bucket:insert")
    @POST
    @Path(value="/b")
    @Fallback(value=BlobStoreFallbacks.NullOnKeyAlreadyExists.class)
    public Bucket createBucket(@QueryParam(value="project") String var1, @BinderParam(value=BindToJsonPayload.class) BucketTemplate var2, InsertBucketOptions var3);

    @Named(value="Bucket:delete")
    @DELETE
    @Path(value="/b/{bucket}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean deleteBucket(@PathParam(value="bucket") String var1);

    @Named(value="Bucket:delete")
    @DELETE
    @Path(value="/b/{bucket}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean deleteBucket(@PathParam(value="bucket") String var1, DeleteBucketOptions var2);

    @Named(value="Bucket:list")
    @GET
    @Produces(value={"application/json"})
    @Path(value="/b")
    public ListPage<Bucket> listBucket(@QueryParam(value="project") String var1);

    @Named(value="Bucket:list")
    @GET
    @Produces(value={"application/json"})
    @Path(value="/b")
    public ListPage<Bucket> listBucket(@QueryParam(value="project") String var1, ListOptions var2);

    @Named(value="Bucket:update")
    @PUT
    @Produces(value={"application/json"})
    @Path(value="/b/{bucket}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Bucket updateBucket(@PathParam(value="bucket") String var1, @BinderParam(value=BindToJsonPayload.class) BucketTemplate var2);

    @Named(value="Bucket:update")
    @PUT
    @Produces(value={"application/json"})
    @Path(value="/b/{bucket}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Bucket updateBucket(@PathParam(value="bucket") String var1, @BinderParam(value=BindToJsonPayload.class) BucketTemplate var2, UpdateBucketOptions var3);

    @Named(value="Bucket:patch")
    @PATCH
    @Produces(value={"application/json"})
    @Path(value="/b/{bucket}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Bucket patchBucket(@PathParam(value="bucket") String var1, @BinderParam(value=BindToJsonPayload.class) BucketTemplate var2);

    @Named(value="Bucket:patch")
    @PATCH
    @Produces(value={"application/json"})
    @Path(value="/b/{bucket}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Bucket patchBucket(@PathParam(value="bucket") String var1, @BinderParam(value=BindToJsonPayload.class) BucketTemplate var2, UpdateBucketOptions var3);
}

