/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.config.external.vault;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Map;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.core.config.external.vault.VaultExternalConfigSupplier;
import org.apache.brooklyn.util.text.Strings;

public class VaultUserPassExternalConfigSupplier
extends VaultExternalConfigSupplier {
    public VaultUserPassExternalConfigSupplier(ManagementContext managementContext, String name, Map<String, String> config) {
        super(managementContext, name, config);
    }

    @Override
    protected String initAndLogIn(Map<String, String> config) {
        ArrayList errors = Lists.newArrayListWithCapacity((int)2);
        String username = config.get("username");
        if (Strings.isBlank((CharSequence)username)) {
            errors.add("missing configuration 'username'");
        }
        String password = config.get("password");
        if (Strings.isBlank((CharSequence)username)) {
            errors.add("missing configuration 'password'");
        }
        if (!errors.isEmpty()) {
            String message = String.format("Problem configuration Vault external config supplier '%s': %s", this.name, Joiner.on((String)System.lineSeparator()).join((Iterable)errors));
            throw new IllegalArgumentException(message);
        }
        String path = "v1/auth/userpass/login/" + username;
        ImmutableMap requestData = ImmutableMap.of((Object)"password", (Object)password);
        ImmutableMap headers = MINIMAL_HEADERS;
        JsonObject response = this.apiPost(path, (ImmutableMap<String, String>)headers, (ImmutableMap<String, String>)requestData);
        return response.getAsJsonObject("auth").get("client_token").getAsString();
    }
}

