/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.effector;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.effector.AddEffector;
import org.apache.brooklyn.core.effector.EffectorBody;
import org.apache.brooklyn.core.effector.Effectors;
import org.apache.brooklyn.core.entity.EntityInitializers;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.guava.Maybe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class CompositeEffector
extends AddEffector {
    private static final Logger LOG = LoggerFactory.getLogger(CompositeEffector.class);
    private static final String ORIGINAL_PREFIX = "original-";
    public static final ConfigKey<List<String>> EFFECTORS = ConfigKeys.newConfigKey(new TypeToken<List<String>>(){}, "effectors", "Effector names to be chained together in the composite effector", ImmutableList.of());
    public static final ConfigKey<Boolean> OVERRIDE = ConfigKeys.newBooleanConfigKey("override", "Wheter additional defined effectors should override pre-existing effector with same name or not (default: false)", Boolean.FALSE);

    public CompositeEffector(ConfigBag params) {
        super(CompositeEffector.newEffectorBuilder(params).build());
    }

    public CompositeEffector(Map<?, ?> params) {
        this(ConfigBag.newInstance(params));
    }

    public static Effectors.EffectorBuilder<List> newEffectorBuilder(ConfigBag params) {
        Effectors.EffectorBuilder<List> eff = AddEffector.newEffectorBuilder(List.class, params);
        eff.impl(new Body(eff.buildAbstract(), params));
        return eff;
    }

    @Override
    public void apply(EntityLocal entity) {
        Maybe effectorMaybe = entity.getEntityType().getEffectorByName(this.effector.getName());
        if (!effectorMaybe.isAbsentOrNull()) {
            Effector original = Effectors.effector((Effector)effectorMaybe.get()).name(ORIGINAL_PREFIX + this.effector.getName()).build();
            ((EntityInternal)entity).getMutableEntityType().addEffector(original);
        }
        super.apply(entity);
    }

    protected static class Body
    extends EffectorBody<List> {
        private final Effector<?> effector;
        private final ConfigBag params;

        public Body(Effector<?> eff, ConfigBag params) {
            this.effector = eff;
            Preconditions.checkNotNull((Object)params.getAllConfigRaw().get(EFFECTORS.getName()), (Object)"Effector names must be supplied when defining this effector");
            this.params = params;
        }

        @Override
        public List<Object> call(ConfigBag params) {
            ConfigBag allConfig = ConfigBag.newInstanceCopying(this.params).putAll(params);
            List<String> effectorNames = EntityInitializers.resolve(allConfig, EFFECTORS);
            Boolean override = allConfig.get(OVERRIDE);
            ArrayList results = Lists.newArrayList();
            if (!override.booleanValue() && this.isStartRedefined()) {
                results.add(this.invokeEffectorNamed(CompositeEffector.ORIGINAL_PREFIX + Startable.START.getName(), params));
            }
            for (String eff : effectorNames) {
                results.add(this.invokeEffectorNamed(eff, params));
            }
            if (!override.booleanValue() && this.isStopRedefined()) {
                results.add(this.invokeEffectorNamed(CompositeEffector.ORIGINAL_PREFIX + Startable.STOP.getName(), params));
            }
            return results;
        }

        private boolean isStartRedefined() {
            return this.isEffectorRedefined(CompositeEffector.ORIGINAL_PREFIX + Startable.START.getName());
        }

        private boolean isStopRedefined() {
            return this.isEffectorRedefined(CompositeEffector.ORIGINAL_PREFIX + Startable.STOP.getName());
        }

        private boolean isEffectorRedefined(String effectorName) {
            return this.entity().getEntityType().getEffectorByName(effectorName).isPresent();
        }

        private Object invokeEffectorNamed(String effectorName, ConfigBag params) {
            LOG.info("{} invoking effector on {}, effector={}, parameters={}", new Object[]{this, this.entity(), effectorName, params});
            Maybe effector = this.entity().getEntityType().getEffectorByName(effectorName);
            if (effector.isAbsent()) {
                throw new IllegalStateException("Cannot find effector " + effectorName);
            }
            return this.entity().invoke((Effector)effector.get(), params.getAllConfig()).getUnchecked();
        }
    }
}

