/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.effector.util;

import java.util.Map;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.entity.Group;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.BasicConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.config.MapConfigKey;
import org.apache.brooklyn.core.effector.AddEffectorInitializerAbstract;
import org.apache.brooklyn.core.effector.EffectorBody;
import org.apache.brooklyn.core.effector.EffectorTasks;
import org.apache.brooklyn.core.effector.Effectors;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.task.BasicExecutionContext;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.apache.brooklyn.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChildrenBatchEffector
extends AddEffectorInitializerAbstract {
    public static final Effector<Object> EFFECTOR = Effectors.effector(Object.class, "childrenBatchEffector").description("Invokes an effector e.g. across children or members").buildAbstract();
    public static final ConfigKey<String> EFFECTOR_NAME = ((BasicConfigKey.Builder)((BasicConfigKey.Builder)((BasicConfigKey.Builder)ConfigKeys.builder(String.class).name("name")).description("Effector name")).defaultValue((String)"childrenBatchEffector")).build();
    public static final ConfigKey<Integer> BATCH_SIZE = ((BasicConfigKey.Builder)((BasicConfigKey.Builder)((BasicConfigKey.Builder)ConfigKeys.builder(Integer.class).name("batchSize")).description("Supply a limit to the number of children updated at a time; 0 (default) means no limit, 1 means do them sequentially")).defaultValue(0)).build();
    public static final ConfigKey<String> EFFECTOR_TO_INVOKE = ((BasicConfigKey.Builder)((BasicConfigKey.Builder)((BasicConfigKey.Builder)ConfigKeys.builder(String.class).name("effectorToInvoke")).description("Name of the effector to invoke; if not supplied will use 'repave'")).defaultValue((String)"repave")).build();
    public static final ConfigKey<Boolean> FAIL_ON_MISSING_EFFECTOR_TO_INVOKE = ((BasicConfigKey.Builder)((BasicConfigKey.Builder)((BasicConfigKey.Builder)ConfigKeys.builder(Boolean.class).name("failOnMissingEffector")).description("Whether to fail (true) or ignore (false, default) if an entity does not have a matching target effector")).defaultValue(false)).build();
    public static final ConfigKey<Boolean> FAIL_ON_EFFECTOR_FAILURE = ((BasicConfigKey.Builder)((BasicConfigKey.Builder)((BasicConfigKey.Builder)ConfigKeys.builder(Boolean.class).name("failOnEffectorFailure")).description("Whether to fail (true) or not (false, default) if an effector invocation failed")).defaultValue(false)).build();
    public static final MapConfigKey<Object> EFFECTOR_ARGS = new MapConfigKey.Builder<Object>(Object.class, "effectorArgs").build();
    private static final Logger log = LoggerFactory.getLogger(ChildrenBatchEffector.class);

    public ChildrenBatchEffector(ConfigBag params) {
        super(params);
    }

    protected Effectors.EffectorBuilder<Object> newEffectorBuilder() {
        Effectors.EffectorBuilder<Object> eff = this.newAbstractEffectorBuilder(Object.class);
        eff.impl(new ChildrenBatchEffectorBody(this.initParams()));
        return eff;
    }

    public ChildrenBatchEffector(Map<String, String> params) {
        this(ConfigBag.newInstance(params));
    }

    private static Effector<Object> makeEffector(ConfigBag paramsCreationTime) {
        return Effectors.effector(EFFECTOR).name(paramsCreationTime.get(EFFECTOR_NAME)).parameter(Integer.class, BATCH_SIZE.getName(), BATCH_SIZE.getDescription(), paramsCreationTime.get(BATCH_SIZE)).parameter(String.class, EFFECTOR_TO_INVOKE.getName(), EFFECTOR_TO_INVOKE.getDescription(), paramsCreationTime.get(EFFECTOR_TO_INVOKE)).parameter(Boolean.class, FAIL_ON_MISSING_EFFECTOR_TO_INVOKE.getName(), FAIL_ON_MISSING_EFFECTOR_TO_INVOKE.getDescription(), paramsCreationTime.get(FAIL_ON_MISSING_EFFECTOR_TO_INVOKE)).parameter(Boolean.class, FAIL_ON_EFFECTOR_FAILURE.getName(), FAIL_ON_EFFECTOR_FAILURE.getDescription(), paramsCreationTime.get(FAIL_ON_EFFECTOR_FAILURE)).parameter(EFFECTOR_ARGS).impl(new EffectorTasks.EffectorBodyTaskFactory<Object>(new ChildrenBatchEffectorBody(paramsCreationTime))).build();
    }

    @Override
    public void apply(EntityLocal entity) {
        ((EntityInternal)entity).getMutableEntityType().addEffector(ChildrenBatchEffector.makeEffector(this.initParams()));
    }

    protected static class ChildrenBatchEffectorBody
    extends EffectorBody<Object> {
        private final ConfigBag paramsCreationTime;

        public ChildrenBatchEffectorBody(ConfigBag paramsCreationTime) {
            this.paramsCreationTime = paramsCreationTime;
        }

        @Override
        public Object call(ConfigBag explicitEffectorInvocationParams) {
            ConfigBag params = ConfigBag.newInstanceCopying(this.paramsCreationTime);
            explicitEffectorInvocationParams.getAllConfig().forEach((k, v) -> {
                if (v != null) {
                    params.putStringKey((String)k, v);
                }
            });
            int batchSize = params.get(BATCH_SIZE);
            ConfigBag argsToPass = ConfigBag.newInstanceCopying(explicitEffectorInvocationParams).putAll((Map)params.get(EFFECTOR_ARGS));
            boolean failOnMissingEffector = params.get(FAIL_ON_MISSING_EFFECTOR_TO_INVOKE);
            boolean failOnEffectorFailure = params.get(FAIL_ON_EFFECTOR_FAILURE);
            MutableList activeTasks = MutableList.of();
            MutableList items = MutableList.copyOf((Iterable)(this.entity() instanceof Group ? ((Group)this.entity()).getMembers() : this.entity().getChildren()));
            int initialSize = items.size();
            int count = 0;
            while (!items.isEmpty()) {
                Entity child = (Entity)items.remove(0);
                String effectorName = params.get(EFFECTOR_TO_INVOKE);
                Effector<?> effector = ((EntityInternal)child).getMutableEntityType().getEffector(effectorName);
                if (effector == null) {
                    if (failOnMissingEffector) {
                        throw new IllegalStateException("No effector '" + effectorName + "' found on " + child);
                    }
                    log.debug("Skipping {} when invoking effector on {} because it does not have an effector '{}'", new Object[]{child, this.entity(), effectorName});
                } else {
                    Task t = Tasks.builder().displayName("Invoking " + effectorName + " on " + child.getDisplayName() + " (" + child.getId() + ")").swallowChildrenFailures(!failOnEffectorFailure).add((TaskAdaptable<?>)Effectors.invocation(effector, argsToPass.getAllConfig(), child)).build();
                    activeTasks.add(t);
                    BasicExecutionContext.getCurrentExecutionContext().submit(t);
                    ++count;
                    this.queue(t);
                }
                if (batchSize <= 0 || items.isEmpty()) continue;
                while (activeTasks.size() >= batchSize) {
                    activeTasks.removeIf(Task::isDone);
                    if (activeTasks.size() < batchSize) continue;
                    try {
                        Tasks.withBlockingDetails("Waiting for something in current batch of " + batchSize + " to complete before submitting the remaining " + items.size() + " invocation" + Strings.s((int)items.size()), () -> {
                            Time.sleep((Duration)Duration.millis((Number)100));
                            return null;
                        });
                    }
                    catch (Exception e) {
                        throw Exceptions.propagate((Throwable)e);
                    }
                }
            }
            return "Invoked " + count + " of " + initialSize + " effectors";
        }
    }
}

