/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.brooklyn.api.internal.AbstractBrooklynObjectSpec;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.core.resolve.jackson.BeanWithTypeUtils;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class BrooklynTags {
    private static final Logger LOG = LoggerFactory.getLogger(BrooklynTags.class);
    public static final String YAML_SPEC_KIND = "yaml_spec";
    public static final String SPEC_HIERARCHY = "spec_hierarchy";
    public static final String DEPTH_IN_ANCESTOR = "depth_in_ancestor";
    public static final String NOTES_KIND = "notes";
    public static final String OWNER_ENTITY_ID = "owner_entity_id";
    public static final String ICON_URL = "icon_url";
    public static final String UPGRADED_FROM = "upgraded_from";
    public static final Object CATALOG_TEMPLATE = "catalog_template";

    public static <T> T findSingleKeyMapValue(String key, TypeToken<T> type, Iterable<Object> tags) {
        if (tags == null) {
            return null;
        }
        for (Object tag : tags) {
            if (!BrooklynTags.isTagSingleKeyMap(tag, key)) continue;
            Object value = ((Map)tag).get(key);
            return TypeCoercions.coerce(value, type);
        }
        return null;
    }

    private static <Object> boolean isTagSingleKeyMap(Object tag, String key) {
        return tag instanceof Map && ((Map)tag).size() == 1 && com.google.common.base.Objects.equal((Object)key, ((Map)tag).keySet().iterator().next());
    }

    public static <T> T findSingleKeyMapValue(String key, Class<T> type, Iterable<Object> tags) {
        return BrooklynTags.findSingleKeyMapValue(key, TypeToken.of(type), tags);
    }

    public static <T> void upsertSingleKeyMapValueTag(AbstractBrooklynObjectSpec<?, ?> spec, String key, T value) {
        MutableList tags = MutableList.copyOf((Iterable)spec.getTags());
        AtomicInteger count = new AtomicInteger();
        List newTags = tags.stream().map(t -> {
            if (BrooklynTags.isTagSingleKeyMap(t, key)) {
                count.incrementAndGet();
                return MutableMap.of((Object)key, (Object)value);
            }
            return t;
        }).collect(Collectors.toList());
        if (count.get() > 0) {
            spec.tagsReplace(newTags);
        } else {
            spec.tag((Object)MutableMap.of((Object)key, value));
        }
    }

    public static <T> void upsertSingleKeyMapValueTag(BrooklynObject.TagSupport tagS, String key, T value) {
        MutableList matchingKeyTags = MutableList.of();
        tagS.getTags().stream().forEach(t -> {
            if (BrooklynTags.isTagSingleKeyMap(t, key)) {
                matchingKeyTags.add(t);
            }
        });
        matchingKeyTags.forEach(arg_0 -> ((BrooklynObject.TagSupport)tagS).removeTag(arg_0));
        tagS.addTag((Object)MutableMap.of((Object)key, value));
    }

    public static NamedStringTag findFirstNamedStringTag(String kind, Iterable<Object> tags) {
        return BrooklynTags.findFirstOfKind(kind, NamedStringTag.class, tags);
    }

    public static List<NamedStringTag> findAllNamedStringTags(String kind, Iterable<Object> tags) {
        return BrooklynTags.findAllOfKind(kind, NamedStringTag.class, tags);
    }

    @Deprecated
    public static NamedStringTag findFirst(String kind, Iterable<Object> tags) {
        return BrooklynTags.findFirstNamedStringTag(kind, tags);
    }

    @Deprecated
    public static List<NamedStringTag> findAll(String kind, Iterable<Object> tags) {
        return BrooklynTags.findAllNamedStringTags(kind, tags);
    }

    public static <T extends HasKind> T findFirstOfKind(String kind, Class<T> type, Iterable<Object> tags) {
        for (Object o : tags) {
            Object k2;
            if (type.isInstance(o)) {
                if (!kind.equals(((HasKind)o).getKind())) continue;
                return (T)((HasKind)o);
            }
            if (!(o instanceof Map) || !kind.equals(k2 = ((Map)o).get("kind"))) continue;
            try {
                return (T)((HasKind)BeanWithTypeUtils.newMapper(null, false, null, true).convertValue(o, type));
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                LOG.warn("Tag '" + o + "' declares kind '" + k2 + "' but does not convert to " + type + " (ignoring): " + e);
            }
        }
        return null;
    }

    public static <T extends HasKind> List<T> findAllOfKind(String kind, Class<T> type, Iterable<Object> tags) {
        MutableList result = MutableList.of();
        for (Object o : tags) {
            Object k2;
            if (type.isInstance(o)) {
                if (!kind.equals(((HasKind)o).getKind())) continue;
                result.add((HasKind)o);
                continue;
            }
            if (!(o instanceof Map) || !kind.equals(k2 = ((Map)o).get("kind"))) continue;
            try {
                result.add(BeanWithTypeUtils.newMapper(null, false, null, true).convertValue(o, type));
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                LOG.warn("Tag '" + o + "' declares kind '" + k2 + "' but does not convert to " + type + " (ignoring): " + e);
            }
        }
        return result;
    }

    public static NamedStringTag newYamlSpecTag(String contents) {
        return new NamedStringTag(YAML_SPEC_KIND, contents);
    }

    public static NamedStringTag newNotesTag(String contents) {
        return new NamedStringTag(NOTES_KIND, contents);
    }

    public static NamedStringTag newOwnerEntityTag(String ownerId) {
        return new NamedStringTag(OWNER_ENTITY_ID, ownerId);
    }

    public static NamedStringTag newIconUrlTag(String iconUrl) {
        return new NamedStringTag(ICON_URL, iconUrl);
    }

    public static NamedStringTag newUpgradedFromTag(String oldVersion) {
        return new NamedStringTag(UPGRADED_FROM, oldVersion);
    }

    public static TraitsTag newTraitsTag(List<Class<?>> interfaces) {
        return new TraitsTag(interfaces);
    }

    public static List<SpecSummary> findSpecHierarchyTag(Iterable<Object> tags) {
        return BrooklynTags.findSingleKeyMapValue(SPEC_HIERARCHY, new TypeToken<List<SpecSummary>>(){}, tags);
    }

    public static Integer getDepthInAncestorTag(Set<Object> tags) {
        return BrooklynTags.findSingleKeyMapValue(DEPTH_IN_ANCESTOR, Integer.class, tags);
    }

    public static class TraitsTag
    extends ListTag<String> {
        public TraitsTag(List<Class<?>> interfaces) {
            super(new ArrayList(Lists.transform(interfaces, (Function)new Function<Class<?>, String>(){

                public String apply(Class<?> input) {
                    return input.getName();
                }
            })));
        }

        @JsonProperty(value="traits")
        public List<String> getTraits() {
            return this.list;
        }
    }

    public static class ListTag<T> {
        @JsonIgnore
        final List<T> list;

        public ListTag(List<T> list) {
            this.list = list;
        }

        public List<T> getList() {
            return this.list;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ListTag that = (ListTag)o;
            return this.list == null ? that.list == null : this.list.equals(that.list);
        }

        public int hashCode() {
            return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.list});
        }
    }

    public static class SpecSummary
    implements Serializable {
        @JsonProperty
        public final String summary;
        @JsonProperty
        public final String format;
        @JsonProperty
        public final Object contents;

        private SpecSummary() {
            this(null, null, null);
        }

        public SpecSummary(String summary, String format, Object contents) {
            this.summary = summary;
            this.format = format;
            this.contents = contents;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SpecSummary that = (SpecSummary)o;
            return Objects.equals(this.summary, that.summary) && Objects.equals(this.format, that.format) && Objects.equals(this.contents, that.contents);
        }

        public int hashCode() {
            return Objects.hash(this.summary, this.format, this.contents);
        }

        public String toString() {
            return "SpecSummary{summary='" + this.summary + '\'' + ", format='" + this.format + '\'' + ", contents=" + this.contents + '}';
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Builder builder(SpecSummary base) {
            return new Builder(base);
        }

        public static void pushToList(List<SpecSummary> specList, SpecSummary newFirstSpecTag) {
            specList.add(0, newFirstSpecTag);
        }

        public static void pushToList(List<SpecSummary> specList, List<SpecSummary> newFirstSpecs) {
            if (newFirstSpecs == null || newFirstSpecs.isEmpty()) {
                return;
            }
            if (newFirstSpecs.size() == 1) {
                SpecSummary.pushToList(specList, newFirstSpecs.iterator().next());
            } else {
                MutableList l = MutableList.copyOf(newFirstSpecs);
                Collections.reverse(l);
                l.forEach(li -> SpecSummary.pushToList(specList, li));
            }
        }

        public static SpecSummary popFromList(List<SpecSummary> specList) {
            if (specList.isEmpty()) {
                return null;
            }
            return specList.remove(0);
        }

        @Deprecated
        @Beta
        public static boolean modifyHeadSummary(List<SpecSummary> specList, java.util.function.Function<String, String> previousSummaryModification) {
            return SpecSummary.modifyHeadSpecSummary(specList, s -> (String)previousSummaryModification.apply(s.summary));
        }

        public static boolean modifyHeadSpecSummary(List<SpecSummary> specList, java.util.function.Function<SpecSummary, String> previousSummaryModification) {
            if (!specList.isEmpty() && previousSummaryModification != null) {
                SpecSummary oldHead = SpecSummary.popFromList(specList);
                SpecSummary newPrevHead = SpecSummary.builder(oldHead).summary(previousSummaryModification.apply(oldHead)).build();
                SpecSummary.pushToList(specList, newPrevHead);
                return true;
            }
            return false;
        }

        public static class Builder {
            private String summary;
            private String format;
            private Object contents;

            private Builder() {
            }

            private Builder(SpecSummary base) {
                this.summary = base.summary;
                this.format = base.format;
                this.contents = base.contents;
            }

            public Builder summary(String summary) {
                this.summary = summary;
                return this;
            }

            public Builder format(String format) {
                this.format = format;
                return this;
            }

            public Builder contents(Object contents) {
                this.contents = contents;
                return this;
            }

            public SpecSummary build() {
                return new SpecSummary(this.summary, this.format, this.contents);
            }
        }
    }

    public static class NamedStringTag
    implements Serializable,
    HasKind {
        private static final long serialVersionUID = 7932098757009051348L;
        @JsonProperty
        final String kind;
        @JsonProperty
        final String contents;

        public NamedStringTag(@JsonProperty(value="kind") String kind, @JsonProperty(value="contents") String contents) {
            this.kind = kind;
            this.contents = contents;
        }

        public String toString() {
            return this.kind + "[" + this.contents + "]";
        }

        @Override
        public String getKind() {
            return this.kind;
        }

        public String getContents() {
            return this.contents;
        }

        public boolean equals(Object other) {
            if (!(other instanceof NamedStringTag)) {
                return false;
            }
            NamedStringTag o = (NamedStringTag)other;
            return com.google.common.base.Objects.equal((Object)this.kind, (Object)o.kind) && com.google.common.base.Objects.equal((Object)this.contents, (Object)o.contents);
        }

        public int hashCode() {
            return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.kind, this.contents});
        }
    }

    public static interface HasKind {
        public String getKind();
    }
}

