/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.objs.proxy;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.mgmt.internal.EntityManagerInternal;
import org.apache.brooklyn.core.mgmt.internal.ManagementTransitionMode;
import org.apache.brooklyn.core.mgmt.rebind.RebindManagerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBrooklynObjectProxyImpl<T extends BrooklynObject>
implements InvocationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractBrooklynObjectProxyImpl.class);
    String id;
    protected T delegate;
    protected Boolean isMaster;
    private WeakHashMap<T, Void> temporaryProxies = new WeakHashMap();
    private static final Set<MethodSignature> OBJECT_METHODS = Sets.newLinkedHashSet();

    protected AbstractBrooklynObjectProxyImpl(T delegate) {
        this.delegate = delegate;
    }

    protected abstract T getProxy(T var1, boolean var2);

    protected abstract void resetProxy(T var1, T var2);

    public synchronized void resetDelegate(T thisProxy, T preferredProxy, T newDelegate) {
        T temporaryProxy;
        if (LOG.isTraceEnabled()) {
            LOG.trace("updating " + Integer.toHexString(System.identityHashCode(thisProxy)) + " to be the same as " + Integer.toHexString(System.identityHashCode(preferredProxy)) + " pointing at " + Integer.toHexString(System.identityHashCode(newDelegate)) + " (" + this.temporaryProxies.size() + " temporary proxies)");
        }
        T oldDelegate = this.delegate;
        this.delegate = newDelegate;
        this.isMaster = null;
        if (this.id != null && newDelegate != null && !newDelegate.getId().equals(this.id)) {
            LOG.warn("Change of ID when delegate " + this.delegate + " assigned to proxy for ID " + this.id + " (ignoring, but indicates something odd occurring)", new Throwable("source of ID change"));
        }
        if (newDelegate == oldDelegate) {
            return;
        }
        if (oldDelegate != null) {
            temporaryProxy = this.getProxy(oldDelegate, true);
            if (temporaryProxy != null) {
                this.temporaryProxies.put(temporaryProxy, null);
            }
            this.resetProxy(oldDelegate, preferredProxy);
        }
        if (newDelegate != null) {
            temporaryProxy = this.getProxy(newDelegate, true);
            if (temporaryProxy != null) {
                this.temporaryProxies.put(temporaryProxy, null);
            }
            this.resetProxy(newDelegate, preferredProxy);
        }
        for (BrooklynObject tp : this.temporaryProxies.keySet()) {
            if (tp == thisProxy || tp == preferredProxy) continue;
            ((AbstractBrooklynObjectProxyImpl)Proxy.getInvocationHandler(tp)).resetDelegate(tp, preferredProxy, newDelegate);
        }
    }

    public String toString() {
        return this.delegate == null ? this.getClass().getName() + "[" + this.getId() + "]" : this.delegate.toString();
    }

    protected boolean isMaster() {
        if (this.isMaster != null) {
            return this.isMaster;
        }
        if (this.delegate == null) {
            return false;
        }
        ManagementContext mgmt = ((EntityInternal)this.delegate).getManagementContext();
        ManagementTransitionMode mode = ((EntityManagerInternal)mgmt.getEntityManager()).getLastManagementTransitionMode(this.delegate.getId());
        Boolean ro = ((EntityInternal)this.delegate).getManagementSupport().isReadOnlyRaw();
        if (mode == null || ro == null) {
            return false;
        }
        boolean isMasterX = !mode.isReadOnly();
        if (isMasterX != (ro == false)) {
            LOG.warn("Inconsistent read-only state for " + this.delegate + " (possibly rebinding); management thinks " + isMasterX + " but entity thinks " + (ro == false));
            return false;
        }
        this.isMaster = isMasterX;
        return isMasterX;
    }

    protected abstract boolean isPermittedReadOnlyMethod(MethodSignature var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        Object result;
        if (proxy == null) {
            throw new IllegalArgumentException("Static methods not supported via proxy on entity " + this.delegate);
        }
        MethodSignature sig = new MethodSignature(m);
        if (this.delegate == null) {
            if ("toString".equals(sig.name)) {
                return this.toString();
            }
            if ("getId".equals(sig.name)) {
                return this.getId();
            }
            if ("hashCode".equals(sig.name)) {
                return this.hashCode();
            }
            if (!"equals".equals(sig.name) || args.length != 1) throw new NullPointerException("Access to proxy on " + this.toString() + " before initialized, method " + m + "; likely the target either is still being initialized or the target had an error when being created/rebinded");
            return this.equals(args[0]);
        }
        if (OBJECT_METHODS.contains(sig)) {
            result = m.invoke(this.delegate, args);
            return result == this.delegate ? this.getProxy(this.delegate, false) : result;
        } else if (this.isPermittedReadOnlyMethod(sig)) {
            result = m.invoke(this.delegate, args);
            return result == this.delegate ? this.getProxy(this.delegate, false) : result;
        } else if (!this.isMaster()) {
            if (this.isMaster != null && !RebindManagerImpl.RebindTracker.isRebinding()) throw new UnsupportedOperationException("Call to '" + sig + "' not permitted on read-only entity " + this.delegate);
            result = m.invoke(this.delegate, args);
            return result == this.delegate ? this.getProxy(this.delegate, false) : result;
        } else {
            result = this.invokeOther(m, args);
        }
        return result == this.delegate ? this.getProxy(this.delegate, false) : result;
    }

    protected Object invokeOther(Method m, Object[] args) throws IllegalAccessException, InvocationTargetException {
        return m.invoke(this.delegate, args);
    }

    @VisibleForTesting
    public T getDelegate() {
        return this.delegate;
    }

    public int hashCode() {
        return this.delegate != null ? this.delegate.hashCode() : (this.id != null ? this.id.hashCode() : -1);
    }

    public boolean equals(Object other) {
        return other == this || (this.delegate != null ? this.delegate.equals(other) : other instanceof BrooklynObject && ((BrooklynObject)other).getId().equals(this.id));
    }

    public String getId() {
        return this.delegate != null ? this.delegate.getId() : this.id;
    }

    static {
        for (Method m : Object.class.getMethods()) {
            OBJECT_METHODS.add(new MethodSignature(m));
        }
    }

    static class MethodSignature {
        private final String name;
        private final Class<?>[] parameterTypes;

        MethodSignature(Method m) {
            this.name = m.getName();
            this.parameterTypes = m.getParameterTypes();
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.name, Arrays.hashCode(this.parameterTypes)});
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MethodSignature)) {
                return false;
            }
            MethodSignature o = (MethodSignature)obj;
            return this.name.equals(o.name) && Arrays.equals(this.parameterTypes, o.parameterTypes);
        }

        public String toString() {
            return this.name + Arrays.toString(this.parameterTypes);
        }
    }
}

