/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.digitalocean2.compute.internal.ImageInRegion;
import org.jclouds.digitalocean2.domain.OperatingSystem;
import org.jclouds.domain.Location;

@Singleton
public class ImageInRegionToImage
implements Function<ImageInRegion, Image> {
    private final Supplier<Set<? extends Location>> locations;

    @Inject
    ImageInRegionToImage(@Memoized Supplier<Set<? extends Location>> locations) {
        this.locations = locations;
    }

    public Image apply(ImageInRegion input) {
        String description = input.image().distribution() + " " + input.image().name();
        ImageBuilder builder = new ImageBuilder();
        builder.id(ImageInRegion.encodeId(input));
        builder.providerId(String.valueOf(input.image().id()));
        builder.name(input.image().name());
        builder.description(description);
        builder.status(Image.Status.AVAILABLE);
        builder.location(this.getLocation(input.region()));
        OperatingSystem os = OperatingSystem.create(input.image().name(), input.image().distribution());
        builder.operatingSystem(org.jclouds.compute.domain.OperatingSystem.builder().name(os.distribution().value()).family(os.distribution().osFamily()).description(description).arch(os.arch()).version(os.version()).is64Bit(os.is64bit()).build());
        ImmutableMap.Builder metadata = ImmutableMap.builder();
        metadata.put((Object)"publicImage", (Object)String.valueOf(input.image().isPublic()));
        builder.userMetadata((Map)metadata.build());
        return builder.build();
    }

    protected Location getLocation(final String region) {
        return (Location)Iterables.find((Iterable)((Iterable)this.locations.get()), (Predicate)new Predicate<Location>(){

            public boolean apply(Location location) {
                return region.equals(location.getId());
            }
        });
    }
}

