/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.miscellaneous.network.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.miscellaneous.network.operator.v1.EgressRouterAddress;
import io.fabric8.openshift.api.model.miscellaneous.network.operator.v1.EgressRouterAddressBuilder;
import io.fabric8.openshift.api.model.miscellaneous.network.operator.v1.EgressRouterAddressFluent;
import io.fabric8.openshift.api.model.miscellaneous.network.operator.v1.EgressRouterInterface;
import io.fabric8.openshift.api.model.miscellaneous.network.operator.v1.EgressRouterInterfaceBuilder;
import io.fabric8.openshift.api.model.miscellaneous.network.operator.v1.EgressRouterInterfaceFluent;
import io.fabric8.openshift.api.model.miscellaneous.network.operator.v1.EgressRouterSpec;
import io.fabric8.openshift.api.model.miscellaneous.network.operator.v1.RedirectConfig;
import io.fabric8.openshift.api.model.miscellaneous.network.operator.v1.RedirectConfigBuilder;
import io.fabric8.openshift.api.model.miscellaneous.network.operator.v1.RedirectConfigFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class EgressRouterSpecFluent<A extends EgressRouterSpecFluent<A>>
extends BaseFluent<A> {
    private ArrayList<EgressRouterAddressBuilder> addresses = new ArrayList();
    private String mode;
    private EgressRouterInterfaceBuilder networkInterface;
    private RedirectConfigBuilder redirect;
    private Map<String, Object> additionalProperties;

    public EgressRouterSpecFluent() {
    }

    public EgressRouterSpecFluent(EgressRouterSpec instance) {
        EgressRouterSpec egressRouterSpec = instance = instance != null ? instance : new EgressRouterSpec();
        if (instance != null) {
            this.withAddresses(instance.getAddresses());
            this.withMode(instance.getMode());
            this.withNetworkInterface(instance.getNetworkInterface());
            this.withRedirect(instance.getRedirect());
            this.withAddresses(instance.getAddresses());
            this.withMode(instance.getMode());
            this.withNetworkInterface(instance.getNetworkInterface());
            this.withRedirect(instance.getRedirect());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToAddresses(int index, EgressRouterAddress item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        EgressRouterAddressBuilder builder = new EgressRouterAddressBuilder(item);
        if (index < 0 || index >= this.addresses.size()) {
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.add(builder);
        } else {
            this._visitables.get((Object)"addresses").add(index, builder);
            this.addresses.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToAddresses(int index, EgressRouterAddress item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        EgressRouterAddressBuilder builder = new EgressRouterAddressBuilder(item);
        if (index < 0 || index >= this.addresses.size()) {
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.add(builder);
        } else {
            this._visitables.get((Object)"addresses").set(index, builder);
            this.addresses.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToAddresses(EgressRouterAddress ... items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        for (EgressRouterAddress item : items) {
            EgressRouterAddressBuilder builder = new EgressRouterAddressBuilder(item);
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToAddresses(Collection<EgressRouterAddress> items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        for (EgressRouterAddress item : items) {
            EgressRouterAddressBuilder builder = new EgressRouterAddressBuilder(item);
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAddresses(EgressRouterAddress ... items) {
        if (this.addresses == null) {
            return (A)((Object)this);
        }
        for (EgressRouterAddress item : items) {
            EgressRouterAddressBuilder builder = new EgressRouterAddressBuilder(item);
            this._visitables.get((Object)"addresses").remove((Object)builder);
            this.addresses.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromAddresses(Collection<EgressRouterAddress> items) {
        if (this.addresses == null) {
            return (A)((Object)this);
        }
        for (EgressRouterAddress item : items) {
            EgressRouterAddressBuilder builder = new EgressRouterAddressBuilder(item);
            this._visitables.get((Object)"addresses").remove((Object)builder);
            this.addresses.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromAddresses(Predicate<EgressRouterAddressBuilder> predicate) {
        if (this.addresses == null) {
            return (A)((Object)this);
        }
        Iterator<EgressRouterAddressBuilder> each = this.addresses.iterator();
        List visitables = this._visitables.get((Object)"addresses");
        while (each.hasNext()) {
            EgressRouterAddressBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<EgressRouterAddress> buildAddresses() {
        return this.addresses != null ? EgressRouterSpecFluent.build(this.addresses) : null;
    }

    public EgressRouterAddress buildAddress(int index) {
        return this.addresses.get(index).build();
    }

    public EgressRouterAddress buildFirstAddress() {
        return this.addresses.get(0).build();
    }

    public EgressRouterAddress buildLastAddress() {
        return this.addresses.get(this.addresses.size() - 1).build();
    }

    public EgressRouterAddress buildMatchingAddress(Predicate<EgressRouterAddressBuilder> predicate) {
        for (EgressRouterAddressBuilder item : this.addresses) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingAddress(Predicate<EgressRouterAddressBuilder> predicate) {
        for (EgressRouterAddressBuilder item : this.addresses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAddresses(List<EgressRouterAddress> addresses) {
        if (this.addresses != null) {
            this._visitables.get((Object)"addresses").clear();
        }
        if (addresses != null) {
            this.addresses = new ArrayList();
            for (EgressRouterAddress item : addresses) {
                this.addToAddresses(item);
            }
        } else {
            this.addresses = null;
        }
        return (A)((Object)this);
    }

    public A withAddresses(EgressRouterAddress ... addresses) {
        if (this.addresses != null) {
            this.addresses.clear();
            this._visitables.remove((Object)"addresses");
        }
        if (addresses != null) {
            for (EgressRouterAddress item : addresses) {
                this.addToAddresses(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasAddresses() {
        return this.addresses != null && !this.addresses.isEmpty();
    }

    public A addNewAddress(String gateway, String ip) {
        return this.addToAddresses(new EgressRouterAddress(gateway, ip));
    }

    public AddressesNested<A> addNewAddress() {
        return new AddressesNested(-1, null);
    }

    public AddressesNested<A> addNewAddressLike(EgressRouterAddress item) {
        return new AddressesNested(-1, item);
    }

    public AddressesNested<A> setNewAddressLike(int index, EgressRouterAddress item) {
        return new AddressesNested(index, item);
    }

    public AddressesNested<A> editAddress(int index) {
        if (this.addresses.size() <= index) {
            throw new RuntimeException("Can't edit addresses. Index exceeds size.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    public AddressesNested<A> editFirstAddress() {
        if (this.addresses.size() == 0) {
            throw new RuntimeException("Can't edit first addresses. The list is empty.");
        }
        return this.setNewAddressLike(0, this.buildAddress(0));
    }

    public AddressesNested<A> editLastAddress() {
        int index = this.addresses.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last addresses. The list is empty.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    public AddressesNested<A> editMatchingAddress(Predicate<EgressRouterAddressBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.addresses.size(); ++i) {
            if (!predicate.test(this.addresses.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching addresses. No match found.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    public String getMode() {
        return this.mode;
    }

    public A withMode(String mode) {
        this.mode = mode;
        return (A)((Object)this);
    }

    public boolean hasMode() {
        return this.mode != null;
    }

    public EgressRouterInterface buildNetworkInterface() {
        return this.networkInterface != null ? this.networkInterface.build() : null;
    }

    public A withNetworkInterface(EgressRouterInterface networkInterface) {
        this._visitables.get((Object)"networkInterface").remove((Object)this.networkInterface);
        if (networkInterface != null) {
            this.networkInterface = new EgressRouterInterfaceBuilder(networkInterface);
            this._visitables.get((Object)"networkInterface").add(this.networkInterface);
        } else {
            this.networkInterface = null;
            this._visitables.get((Object)"networkInterface").remove((Object)this.networkInterface);
        }
        return (A)((Object)this);
    }

    public boolean hasNetworkInterface() {
        return this.networkInterface != null;
    }

    public NetworkInterfaceNested<A> withNewNetworkInterface() {
        return new NetworkInterfaceNested(null);
    }

    public NetworkInterfaceNested<A> withNewNetworkInterfaceLike(EgressRouterInterface item) {
        return new NetworkInterfaceNested(item);
    }

    public NetworkInterfaceNested<A> editNetworkInterface() {
        return this.withNewNetworkInterfaceLike(Optional.ofNullable(this.buildNetworkInterface()).orElse(null));
    }

    public NetworkInterfaceNested<A> editOrNewNetworkInterface() {
        return this.withNewNetworkInterfaceLike(Optional.ofNullable(this.buildNetworkInterface()).orElse(new EgressRouterInterfaceBuilder().build()));
    }

    public NetworkInterfaceNested<A> editOrNewNetworkInterfaceLike(EgressRouterInterface item) {
        return this.withNewNetworkInterfaceLike(Optional.ofNullable(this.buildNetworkInterface()).orElse(item));
    }

    public RedirectConfig buildRedirect() {
        return this.redirect != null ? this.redirect.build() : null;
    }

    public A withRedirect(RedirectConfig redirect) {
        this._visitables.get((Object)"redirect").remove((Object)this.redirect);
        if (redirect != null) {
            this.redirect = new RedirectConfigBuilder(redirect);
            this._visitables.get((Object)"redirect").add(this.redirect);
        } else {
            this.redirect = null;
            this._visitables.get((Object)"redirect").remove((Object)this.redirect);
        }
        return (A)((Object)this);
    }

    public boolean hasRedirect() {
        return this.redirect != null;
    }

    public RedirectNested<A> withNewRedirect() {
        return new RedirectNested(null);
    }

    public RedirectNested<A> withNewRedirectLike(RedirectConfig item) {
        return new RedirectNested(item);
    }

    public RedirectNested<A> editRedirect() {
        return this.withNewRedirectLike(Optional.ofNullable(this.buildRedirect()).orElse(null));
    }

    public RedirectNested<A> editOrNewRedirect() {
        return this.withNewRedirectLike(Optional.ofNullable(this.buildRedirect()).orElse(new RedirectConfigBuilder().build()));
    }

    public RedirectNested<A> editOrNewRedirectLike(RedirectConfig item) {
        return this.withNewRedirectLike(Optional.ofNullable(this.buildRedirect()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EgressRouterSpecFluent that = (EgressRouterSpecFluent)((Object)o);
        if (!Objects.equals(this.addresses, that.addresses)) {
            return false;
        }
        if (!Objects.equals(this.mode, that.mode)) {
            return false;
        }
        if (!Objects.equals((Object)this.networkInterface, (Object)that.networkInterface)) {
            return false;
        }
        if (!Objects.equals((Object)this.redirect, (Object)that.redirect)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.addresses, this.mode, this.networkInterface, this.redirect, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.addresses != null && !this.addresses.isEmpty()) {
            sb.append("addresses:");
            sb.append(this.addresses + ",");
        }
        if (this.mode != null) {
            sb.append("mode:");
            sb.append(this.mode + ",");
        }
        if (this.networkInterface != null) {
            sb.append("networkInterface:");
            sb.append((Object)((Object)this.networkInterface) + ",");
        }
        if (this.redirect != null) {
            sb.append("redirect:");
            sb.append((Object)((Object)this.redirect) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class RedirectNested<N>
    extends RedirectConfigFluent<RedirectNested<N>>
    implements Nested<N> {
        RedirectConfigBuilder builder;

        RedirectNested(RedirectConfig item) {
            this.builder = new RedirectConfigBuilder(this, item);
        }

        public N and() {
            return (N)EgressRouterSpecFluent.this.withRedirect(this.builder.build());
        }

        public N endRedirect() {
            return this.and();
        }
    }

    public class NetworkInterfaceNested<N>
    extends EgressRouterInterfaceFluent<NetworkInterfaceNested<N>>
    implements Nested<N> {
        EgressRouterInterfaceBuilder builder;

        NetworkInterfaceNested(EgressRouterInterface item) {
            this.builder = new EgressRouterInterfaceBuilder(this, item);
        }

        public N and() {
            return (N)EgressRouterSpecFluent.this.withNetworkInterface(this.builder.build());
        }

        public N endNetworkInterface() {
            return this.and();
        }
    }

    public class AddressesNested<N>
    extends EgressRouterAddressFluent<AddressesNested<N>>
    implements Nested<N> {
        EgressRouterAddressBuilder builder;
        int index;

        AddressesNested(int index, EgressRouterAddress item) {
            this.index = index;
            this.builder = new EgressRouterAddressBuilder(this, item);
        }

        public N and() {
            return (N)EgressRouterSpecFluent.this.setToAddresses(this.index, this.builder.build());
        }

        public N endAddress() {
            return this.and();
        }
    }
}

