/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.nosql.hazelcast;

import org.apache.brooklyn.api.catalog.Catalog;
import org.apache.brooklyn.api.entity.ImplementedBy;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.location.PortRanges;
import org.apache.brooklyn.core.sensor.BasicAttributeSensorAndConfigKey;
import org.apache.brooklyn.core.sensor.PortAttributeSensorAndConfigKey;
import org.apache.brooklyn.entity.java.UsesJava;
import org.apache.brooklyn.entity.java.UsesJmx;
import org.apache.brooklyn.entity.nosql.hazelcast.HazelcastNodeImpl;
import org.apache.brooklyn.entity.software.base.SoftwareProcess;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.apache.brooklyn.util.javalang.JavaClassNames;

@Catalog(name="Hazelcast Node", description="Hazelcast is a clustering and highly scalable data distribution platform for Java.")
@ImplementedBy(value=HazelcastNodeImpl.class)
public interface HazelcastNode
extends SoftwareProcess,
UsesJava,
UsesJmx {
    @SetFromFlag(value="version")
    public static final ConfigKey<String> SUGGESTED_VERSION = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.SUGGESTED_VERSION, (Object)"3.5.4");
    @SetFromFlag(value="downloadUrl")
    public static final BasicAttributeSensorAndConfigKey<String> DOWNLOAD_URL = new BasicAttributeSensorAndConfigKey(SoftwareProcess.DOWNLOAD_URL, (Object)"https://repo1.maven.org/maven2/com/hazelcast/hazelcast/${version}/hazelcast-${version}.jar");
    @SetFromFlag(value="configTemplateUrl")
    public static final ConfigKey<String> CONFIG_TEMPLATE_URL = ConfigKeys.newStringConfigKey((String)"hazelcast.node.config.templateUrl", (String)"Template file (in freemarker format) for the Hazelcat config file", (String)JavaClassNames.resolveClasspathUrl(HazelcastNode.class, (String)"hazelcast-brooklyn.xml"));
    @SetFromFlag(value="configFileName")
    public static final ConfigKey<String> CONFIG_FILE_NAME = ConfigKeys.newStringConfigKey((String)"hazelcast.node.config.fileName", (String)"Name of the Hazelcast config file", (String)"hazelcast.xml");
    @SetFromFlag(value="nodeName")
    public static final BasicAttributeSensorAndConfigKey.StringAttributeSensorAndConfigKey NODE_NAME = new BasicAttributeSensorAndConfigKey.StringAttributeSensorAndConfigKey("hazelcast.node.name", "Node name (or randomly selected if not set", null);
    @SetFromFlag(value="nodeHeapMemorySize")
    public static final ConfigKey<String> NODE_HEAP_MEMORY_SIZE = ConfigKeys.newStringConfigKey((String)"hazelcast.node.heap.memory.size", (String)"Node's heap memory size (-Xmx and -Xms) in megabytes. Default: 256m", (String)"256m");
    @SetFromFlag(value="nodePort")
    public static final PortAttributeSensorAndConfigKey NODE_PORT = new PortAttributeSensorAndConfigKey("hazelcast.node.port", "Hazelcast communication port", (Object)PortRanges.fromString((String)"5701+"));
    @SetFromFlag(value="nodeClusterName")
    public static final BasicAttributeSensorAndConfigKey<String> NODE_CLUSTER_NAME = new BasicAttributeSensorAndConfigKey(String.class, "hazelcast.node.cluster.name", "Name of the Hazelcast cluster which node is part of", (Object)"");
    @SetFromFlag(value="groupName")
    public static final ConfigKey<String> GROUP_NAME = ConfigKeys.newStringConfigKey((String)"hazelcast.group.name", (String)"Group name", (String)"brooklyn");
    @SetFromFlag(value="groupPassword")
    public static final ConfigKey<String> GROUP_PASSWORD = ConfigKeys.newStringConfigKey((String)"hazelcast.group.password", (String)"Group password", (String)"brooklyn");

    public String getNodeName();

    public Integer getNodePort();

    public String getGroupName();

    public String getGroupPassword();

    public String getHostname();

    public String getHostAddress();

    public String getPrivateIpAddress();

    public String getListenAddress();

    public String getHeapMemorySize();
}

