/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.launcher.config;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.brooklyn.config.ConfigMap;
import org.apache.brooklyn.core.BrooklynVersion;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.os.Os;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomResourceLocator {
    private static final Logger log = LoggerFactory.getLogger(CustomResourceLocator.class);
    protected final ResourceUtils r;
    private ConfigMap config;
    private static List<ResourceLocator> locators = new ArrayList<ResourceLocator>();

    public CustomResourceLocator(ConfigMap config, ResourceUtils r) {
        this.config = config;
        this.r = r;
    }

    public static void registerAlternateLocator(ResourceLocator locator) {
        locators.add(0, locator);
    }

    public static ResourceLocator getLocatorFor(String url, ConfigMap config) {
        for (ResourceLocator l : locators) {
            if (!l.isApplicable(url, config)) continue;
            return l;
        }
        return null;
    }

    public InputStream getResourceFromUrl(String url) {
        try {
            return this.r.getResourceFromUrl(url);
        }
        catch (Exception e) {
            ResourceLocator locator = CustomResourceLocator.getLocatorFor(url, this.config);
            if (locator != null) {
                log.debug("Unable to load resource from " + url + "; attempting with locator " + locator);
                try {
                    InputStream result = locator.locate(url, this.config, this.r);
                    if (result != null) {
                        return result;
                    }
                    if (result == null) {
                        log.warn("Unable to load resource from " + url + ", even with custom locator; rethrowing original exception");
                    }
                }
                catch (Exception e2) {
                    log.warn("Unable to load resource from " + url + ", even with custom locator; rethrowing original exception, new exception is: " + e2);
                }
            }
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public static class SearchingClassPathInDevMode
    implements ResourceLocator {
        private final String urlToSearchFor;
        private final String classpathSuffixToSearchFor;
        private final String classpathSuffixToUse;

        public SearchingClassPathInDevMode(String urlToSearchFor, String classpathSuffixToSearchFor, String classpathSuffixToUse) {
            this.urlToSearchFor = urlToSearchFor;
            this.classpathSuffixToSearchFor = Os.nativePath((String)classpathSuffixToSearchFor);
            this.classpathSuffixToUse = classpathSuffixToUse;
        }

        @Override
        public boolean isApplicable(String url, ConfigMap config) {
            return BrooklynVersion.isDevelopmentEnvironment() && this.urlToSearchFor.equals(url);
        }

        @Override
        public InputStream locate(String url, ConfigMap config, ResourceUtils r) {
            String cp = System.getProperty("java.class.path");
            int cpi = cp.indexOf(this.classpathSuffixToSearchFor);
            if (cpi == -1) {
                return null;
            }
            String path = cp.substring(0, cpi);
            int lps = path.lastIndexOf(File.pathSeparatorChar);
            if (lps >= 0) {
                path = path.substring(lps + 1);
            }
            path = path + this.classpathSuffixToUse;
            log.debug("Looking for " + url + " in revised location " + path);
            InputStream result = r.getResourceFromUrl(path);
            log.info("Using " + url + " from revised location " + path);
            return result;
        }
    }

    public static interface ResourceLocator {
        public boolean isApplicable(String var1, ConfigMap var2);

        public InputStream locate(String var1, ConfigMap var2, ResourceUtils var3);
    }
}

