/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.entity;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.internal.AbstractBrooklynObjectSpec;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.api.objs.EntityAdjunct;
import org.apache.brooklyn.api.policy.Policy;
import org.apache.brooklyn.api.policy.PolicySpec;
import org.apache.brooklyn.api.sensor.Enricher;
import org.apache.brooklyn.api.sensor.EnricherSpec;
import org.apache.brooklyn.api.sensor.Feed;
import org.apache.brooklyn.core.entity.BrooklynConfigKeys;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.core.objs.AbstractBrooklynObject;
import org.apache.brooklyn.core.objs.AbstractEntityAdjunct;
import org.apache.brooklyn.core.objs.proxy.EntityAdjunctProxyImpl;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.guava.Maybe;

public class EntityAdjuncts {
    public static final List<String> SYSTEM_ENRICHER_UNIQUE_TAGS = ImmutableList.of((Object)"service.isUp if no service.notUp.indicators", (Object)"service.state.actual", (Object)"service-lifecycle-indicators-from-children-and-members", (Object)"service-not-up-indicators-from-children-and-members");

    public static <T extends EntityAdjunct> Maybe<T> tryFindWithUniqueTag(Iterable<T> adjuncts, Object tag) {
        Preconditions.checkNotNull((Object)tag, (Object)"tag");
        for (EntityAdjunct adjunct : adjuncts) {
            if (!tag.equals(adjunct.getUniqueTag())) continue;
            return Maybe.of((Object)adjunct);
        }
        return Maybe.absent((String)("Not found with tag " + tag));
    }

    public static boolean matchesTagOrIdOrAdjunctItself(EntityAdjunct adjunct, Object tagOrIdOrAdjunctItself) {
        if (adjunct == null || tagOrIdOrAdjunctItself == null) {
            return false;
        }
        if (tagOrIdOrAdjunctItself.equals(adjunct)) {
            return true;
        }
        if (tagOrIdOrAdjunctItself instanceof EntityAdjunct) {
            return false;
        }
        if (tagOrIdOrAdjunctItself.equals(adjunct.getUniqueTag())) {
            return true;
        }
        return tagOrIdOrAdjunctItself.equals(adjunct.config().get(BrooklynConfigKeys.PLAN_ID));
    }

    public static <T extends EntityAdjunct> Maybe<T> tryFind(Iterable<T> adjuncts, Object tagOrIdOrAdjunctItself) {
        if (tagOrIdOrAdjunctItself == null) {
            return Maybe.absent((String)"Asked to find null");
        }
        for (EntityAdjunct adjunct : adjuncts) {
            if (!EntityAdjuncts.matchesTagOrIdOrAdjunctItself(adjunct, tagOrIdOrAdjunctItself)) continue;
            return Maybe.of((Object)adjunct);
        }
        return Maybe.absent((String)"Not found");
    }

    public static Maybe<EntityAdjunct> tryFindOnEntity(Entity entity, Object tagOrIdOrAdjunctItself) {
        if (tagOrIdOrAdjunctItself == null) {
            return Maybe.absent((String)"Asked to find null");
        }
        Object result = EntityAdjuncts.tryFind(entity.policies(), tagOrIdOrAdjunctItself);
        if (result.isPresent()) {
            return result;
        }
        result = EntityAdjuncts.tryFind(entity.enrichers(), tagOrIdOrAdjunctItself);
        if (result.isPresent()) {
            return result;
        }
        result = EntityAdjuncts.tryFind(((EntityInternal)entity).feeds(), tagOrIdOrAdjunctItself);
        if (result.isPresent()) {
            return result;
        }
        return Maybe.absent((String)("Adjunct/policy not found: " + tagOrIdOrAdjunctItself));
    }

    public static List<Enricher> getNonSystemEnrichers(Entity entity) {
        MutableList result = MutableList.copyOf((Iterable)entity.enrichers());
        Iterator ri = result.iterator();
        while (ri.hasNext()) {
            if (!EntityAdjuncts.isSystemEnricher((Enricher)ri.next())) continue;
            ri.remove();
        }
        return result;
    }

    public static boolean isSystemEnricher(Enricher enr) {
        if (enr.getUniqueTag() == null) {
            return false;
        }
        return SYSTEM_ENRICHER_UNIQUE_TAGS.contains(enr.getUniqueTag());
    }

    @Beta
    public static Lifecycle inferAdjunctStatus(EntityAdjunct a) {
        if (a.isRunning()) {
            return Lifecycle.RUNNING;
        }
        if (a.isDestroyed()) {
            return Lifecycle.DESTROYED;
        }
        if (a instanceof Policy) {
            if (((Policy)a).isSuspended()) {
                return Lifecycle.STOPPED;
            }
            return Lifecycle.CREATED;
        }
        if (a instanceof Feed) {
            if (((Feed)a).isSuspended()) {
                return Lifecycle.STOPPED;
            }
            if (((Feed)a).isActivated()) {
                return Lifecycle.STARTING;
            }
            return Lifecycle.CREATED;
        }
        return Lifecycle.CREATED;
    }

    public static <T extends EntityAdjunct> T createProxyForInstance(Class<T> adjunctType, @Nonnull T delegate) {
        return (T)((EntityAdjunct)Proxy.newProxyInstance(EntityAdjuncts.class.getClassLoader(), new Class[]{adjunctType, EntityAdjunctProxyable.class}, (InvocationHandler)new EntityAdjunctProxyImpl((EntityAdjunct)Preconditions.checkNotNull(delegate))));
    }

    public static <T extends EntityAdjunct> T createProxyForId(Class<T> adjunctType, String id) {
        return (T)((EntityAdjunct)Proxy.newProxyInstance(EntityAdjuncts.class.getClassLoader(), new Class[]{adjunctType, EntityAdjunctProxyable.class}, (InvocationHandler)new EntityAdjunctProxyImpl(id)));
    }

    public static <T extends BrooklynObject> Maybe<Entity> getEntity(T value, boolean treatDefinitelyMissingAsAbsent) {
        if (value instanceof Entity) {
            return Maybe.of((Object)((Entity)value));
        }
        if (value instanceof EntityAdjunct) {
            Function handleNull = mv -> {
                if (!treatDefinitelyMissingAsAbsent || mv.isAbsent() || mv.isPresentAndNonNull()) {
                    return mv;
                }
                return Maybe.absentNull((String)"entity definitely not set on adjunct");
            };
            if (value instanceof EntityAdjunctProxyable) {
                return (Maybe)handleNull.apply((Object)Maybe.ofAllowingNull((Object)((EntityAdjunctProxyable)value).getEntity()));
            }
            if (value instanceof AbstractEntityAdjunct) {
                return (Maybe)handleNull.apply((Object)Maybe.ofAllowingNull((Object)((AbstractEntityAdjunct)value).getEntity()));
            }
            return Maybe.absent((String)"adjunct does not supply way to detect if entity set");
        }
        return Maybe.absent((String)("brooklyn object " + value + " not supported for entity retrieval"));
    }

    public static boolean removeAdjunct(Entity entity, EntityAdjunct policy) {
        if (policy instanceof Policy) {
            return entity.policies().remove((Policy)policy);
        }
        if (policy instanceof Enricher) {
            return entity.enrichers().remove((Enricher)policy);
        }
        if (policy instanceof Feed) {
            return ((EntityInternal)entity).feeds().remove((Feed)policy);
        }
        if (policy == null) {
            return false;
        }
        throw new IllegalArgumentException("Unexpected adjunct type " + policy.getClass() + " " + policy);
    }

    public static BrooklynObject addAdjunct(Entity entity, AbstractBrooklynObjectSpec spec) {
        if (spec instanceof PolicySpec) {
            return entity.policies().add((PolicySpec)spec);
        }
        if (spec instanceof EnricherSpec) {
            return entity.enrichers().add((EnricherSpec)spec);
        }
        if (spec == null) {
            return null;
        }
        throw new IllegalArgumentException("Unexpected adjunct type " + spec.getClass() + " " + spec);
    }

    @Beta
    public static BrooklynObject addAdjunct(Entity entity, EntityAdjunct spec) {
        if (spec instanceof Policy) {
            entity.policies().add(EntityAdjuncts.init(((EntityInternal)entity).getManagementContext(), (Policy)spec));
            return (Policy)spec;
        }
        if (spec instanceof Enricher) {
            entity.enrichers().add(EntityAdjuncts.init(((EntityInternal)entity).getManagementContext(), (Enricher)spec));
            return (Enricher)spec;
        }
        if (spec instanceof Feed) {
            ((EntityInternal)entity).feeds().add(EntityAdjuncts.init(((EntityInternal)entity).getManagementContext(), (Feed)spec));
            return (Feed)spec;
        }
        if (spec == null) {
            return null;
        }
        throw new IllegalArgumentException("Unexpected adjunct type " + spec.getClass() + " " + spec);
    }

    private static <T extends BrooklynObject> T init(ManagementContext mgmt, T adjunct) {
        ((AbstractBrooklynObject)adjunct).setManagementContext((ManagementContextInternal)mgmt);
        ((AbstractBrooklynObject)adjunct).init();
        return adjunct;
    }

    public static interface EntityAdjunctProxyable
    extends EntityAdjunct {
        public Entity getEntity();
    }
}

